/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.gcc;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativebinaries.toolchain.internal.ArgsTransformer;
import org.gradle.nativebinaries.toolchain.internal.CommandLineTool;
import org.gradle.nativebinaries.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.MutableCommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.NativeCompileSpec;
import org.gradle.nativebinaries.toolchain.internal.ShortCircuitArgsTransformer;
import org.gradle.nativebinaries.toolchain.internal.SingleSourceCompileArgTransformer;
import org.gradle.nativebinaries.toolchain.internal.gcc.GccOptionsFileArgTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativeCompiler<T extends NativeCompileSpec>
implements Compiler<T> {
    private final CommandLineTool commandLineTool;
    private final ArgsTransformer<T> argsTransfomer;
    private final CommandLineToolInvocation baseInvocation;
    private String objectFileSuffix;
    private final boolean useCommandFile;

    public NativeCompiler(CommandLineTool commandLineTool, CommandLineToolInvocation baseInvocation, ArgsTransformer<T> argsTransformer, String objectFileSuffix, boolean useCommandFile) {
        this.baseInvocation = baseInvocation;
        this.objectFileSuffix = objectFileSuffix;
        this.useCommandFile = useCommandFile;
        this.argsTransfomer = argsTransformer;
        this.commandLineTool = commandLineTool;
    }

    public WorkResult execute(T spec) {
        boolean windowsPathLimitation = OperatingSystem.current().isWindows();
        MutableCommandLineToolInvocation invocation = this.baseInvocation.copy();
        invocation.setWorkDirectory(spec.getObjectFileDir());
        if (this.useCommandFile) {
            invocation.addPostArgsAction(new GccOptionsFileArgTransformer(spec.getTempDir()));
        }
        Transformer<List<String>, File> outputFileArgTransformer = new Transformer<List<String>, File>(){

            public List<String> transform(File outputFile) {
                return Arrays.asList("-o", outputFile.getAbsolutePath());
            }
        };
        for (File sourceFile : spec.getSourceFiles()) {
            SingleSourceCompileArgTransformer<T> argTransformer = new SingleSourceCompileArgTransformer<T>(sourceFile, this.objectFileSuffix, new ShortCircuitArgsTransformer<T>(this.argsTransfomer), windowsPathLimitation, outputFileArgTransformer);
            invocation.setArgs(argTransformer.transform(spec));
            this.commandLineTool.execute(invocation);
        }
        return new SimpleWorkResult(!spec.getSourceFiles().isEmpty());
    }
}

