/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.gcc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativebinaries.toolchain.internal.ArgsTransformer;
import org.gradle.nativebinaries.toolchain.internal.MacroArgsConverter;
import org.gradle.nativebinaries.toolchain.internal.NativeCompileSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GccCompilerArgsTransformer<T extends NativeCompileSpec>
implements ArgsTransformer<T> {
    GccCompilerArgsTransformer() {
    }

    public List<String> transform(T spec) {
        ArrayList<String> args = new ArrayList<String>();
        Collections.addAll(args, "-x", this.getLanguage());
        for (String macroArg : new MacroArgsConverter().transform(spec.getMacros())) {
            args.add("-D" + macroArg);
        }
        args.addAll(spec.getAllArgs());
        args.add("-c");
        if (spec.isPositionIndependentCode() && !OperatingSystem.current().isWindows()) {
            args.add("-fPIC");
        }
        for (File file : spec.getIncludeRoots()) {
            args.add("-I");
            args.add(file.getAbsolutePath());
        }
        return args;
    }

    protected abstract String getLanguage();
}

