/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.gcc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativebinaries.internal.CompilerOutputFileNamingScheme;
import org.gradle.nativebinaries.language.assembler.internal.AssembleSpec;
import org.gradle.nativebinaries.toolchain.internal.ArgsTransformer;
import org.gradle.nativebinaries.toolchain.internal.CommandLineTool;
import org.gradle.nativebinaries.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativebinaries.toolchain.internal.MutableCommandLineToolInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Assembler
implements Compiler<AssembleSpec> {
    private final CommandLineTool commandLineTool;
    private final CommandLineToolInvocation baseInvocation;
    private String outputFileSuffix;

    public Assembler(CommandLineTool commandLineTool, CommandLineToolInvocation baseInvocation, String outputFileSuffix) {
        this.commandLineTool = commandLineTool;
        this.baseInvocation = baseInvocation;
        this.outputFileSuffix = outputFileSuffix;
    }

    public WorkResult execute(AssembleSpec spec) {
        MutableCommandLineToolInvocation invocation = this.baseInvocation.copy();
        invocation.setWorkDirectory(spec.getObjectFileDir());
        for (File sourceFile : spec.getSourceFiles()) {
            AssembleSpecToArgsList arguments = new AssembleSpecToArgsList(sourceFile, spec.getObjectFileDir(), this.outputFileSuffix);
            invocation.setArgs((List)arguments.transform(spec));
            this.commandLineTool.execute(invocation);
        }
        return new SimpleWorkResult(!spec.getSourceFiles().isEmpty());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AssembleSpecToArgsList
    implements ArgsTransformer<AssembleSpec> {
        private final File inputFile;
        private final File outputFile;

        public AssembleSpecToArgsList(File inputFile, File objectFileRootDir, String outputFileSuffix) {
            this.inputFile = inputFile;
            this.outputFile = new CompilerOutputFileNamingScheme().withOutputBaseFolder(objectFileRootDir).withObjectFileNameSuffix(outputFileSuffix).map(inputFile);
        }

        public List<String> transform(AssembleSpec spec) {
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(spec.getAllArgs());
            if (!this.outputFile.getParentFile().exists()) {
                this.outputFile.getParentFile().mkdirs();
            }
            Collections.addAll(args, "-o", this.outputFile.getAbsolutePath());
            args.add(this.inputFile.getAbsolutePath());
            return args;
        }
    }
}

