/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal.gcc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.Actions;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.nativebinaries.platform.internal.ArchitectureInternal;
import org.gradle.nativebinaries.toolchain.CommandLineToolConfiguration;
import org.gradle.nativebinaries.toolchain.PlatformConfigurableToolChain;
import org.gradle.nativebinaries.toolchain.TargetedPlatformToolChain;
import org.gradle.nativebinaries.toolchain.internal.ExtendableToolChain;
import org.gradle.nativebinaries.toolchain.internal.PlatformToolChain;
import org.gradle.nativebinaries.toolchain.internal.ToolChainAvailability;
import org.gradle.nativebinaries.toolchain.internal.UnavailablePlatformToolChain;
import org.gradle.nativebinaries.toolchain.internal.gcc.CommandLineToolSearchResult;
import org.gradle.nativebinaries.toolchain.internal.gcc.DefaultGccPlatformToolChain;
import org.gradle.nativebinaries.toolchain.internal.gcc.GccPlatformToolChain;
import org.gradle.nativebinaries.toolchain.internal.gcc.TargetPlatformConfiguration;
import org.gradle.nativebinaries.toolchain.internal.tools.ConfiguredToolRegistry;
import org.gradle.nativebinaries.toolchain.internal.tools.GccCommandLineToolConfigurationInternal;
import org.gradle.nativebinaries.toolchain.internal.tools.ToolSearchPath;
import org.gradle.process.internal.ExecActionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGccCompatibleToolChain
extends ExtendableToolChain
implements PlatformConfigurableToolChain {
    private final ExecActionFactory execActionFactory;
    private final ToolSearchPath toolSearchPath;
    private final List<TargetPlatformConfiguration> platformConfigs = new ArrayList<TargetPlatformConfiguration>();
    private final Instantiator instantiator;
    private int configInsertLocation;

    public AbstractGccCompatibleToolChain(String name, OperatingSystem operatingSystem, FileResolver fileResolver, ExecActionFactory execActionFactory, ToolSearchPath toolSearchPath, Instantiator instantiator) {
        super(GccCommandLineToolConfigurationInternal.class, name, operatingSystem, fileResolver, instantiator);
        this.execActionFactory = execActionFactory;
        this.toolSearchPath = toolSearchPath;
        this.instantiator = instantiator;
        this.target(new ToolChainDefaultArchitecture());
        this.target(new Intel32Architecture());
        this.target(new Intel64Architecture());
        this.configInsertLocation = 0;
    }

    protected CommandLineToolSearchResult locate(GccCommandLineToolConfigurationInternal gccTool) {
        return this.toolSearchPath.locate(gccTool.getToolType(), gccTool.getExecutable());
    }

    public List<File> getPath() {
        return this.toolSearchPath.getPath();
    }

    public void path(Object ... pathEntries) {
        for (Object path : pathEntries) {
            this.toolSearchPath.path(this.resolve(path));
        }
    }

    protected void initTools(TargetedPlatformToolChain targetedPlatformToolChain, ToolChainAvailability availability) {
        SortedMap allTools = targetedPlatformToolChain.getAsMap();
        boolean found = false;
        for (Object o : allTools.values()) {
            GccCommandLineToolConfigurationInternal tool = (GccCommandLineToolConfigurationInternal)o;
            found |= this.toolSearchPath.locate(tool.getToolType(), tool.getExecutable()).isAvailable();
        }
        if (!found) {
            GccCommandLineToolConfigurationInternal cCompiler = (GccCommandLineToolConfigurationInternal)this.getByName("cCompiler");
            availability.mustBeAvailable(this.locate(cCompiler));
        }
    }

    @Override
    public void target(String platformName) {
        this.target(platformName, (Action<? super TargetedPlatformToolChain>)Actions.doNothing());
    }

    @Override
    public void target(String platformName, Action<? super TargetedPlatformToolChain> action) {
        this.target(new DefaultTargetPlatformConfiguration(Arrays.asList(platformName), action));
    }

    public void target(List<String> platformNames, Action<? super TargetedPlatformToolChain> action) {
        this.target(new DefaultTargetPlatformConfiguration(platformNames, action));
    }

    void target(TargetPlatformConfiguration targetPlatformConfiguration) {
        this.platformConfigs.add(this.configInsertLocation, targetPlatformConfiguration);
        ++this.configInsertLocation;
    }

    @Override
    public PlatformToolChain select(Platform targetPlatform) {
        TargetPlatformConfiguration targetPlatformConfigurationConfiguration = this.getPlatformConfiguration(targetPlatform);
        ToolChainAvailability result = new ToolChainAvailability();
        if (targetPlatformConfigurationConfiguration == null) {
            result.unavailable(String.format("Don't know how to build for platform '%s'.", targetPlatform.getName()));
            return new UnavailablePlatformToolChain(result);
        }
        DefaultGccPlatformToolChain configurableToolChain = (DefaultGccPlatformToolChain)this.instantiator.newInstance(DefaultGccPlatformToolChain.class, new Object[]{CommandLineToolConfiguration.class, this.getAsMap(), this.instantiator, this.getName(), this.getDisplayName()});
        targetPlatformConfigurationConfiguration.apply(configurableToolChain);
        this.initTools(configurableToolChain, result);
        if (!result.isAvailable()) {
            return new UnavailablePlatformToolChain(result);
        }
        ConfiguredToolRegistry platformTools = new ConfiguredToolRegistry((Iterable<? extends CommandLineToolConfiguration>)((Object)configurableToolChain));
        String objectFileSuffix = targetPlatform.getOperatingSystem().isWindows() ? ".obj" : ".o";
        return new GccPlatformToolChain(this.toolSearchPath, platformTools, this.execActionFactory, objectFileSuffix, this.canUseCommandFile());
    }

    protected TargetPlatformConfiguration getPlatformConfiguration(Platform targetPlatform) {
        for (TargetPlatformConfiguration platformConfig : this.platformConfigs) {
            if (!platformConfig.supportsPlatform(targetPlatform)) continue;
            return platformConfig;
        }
        return null;
    }

    protected boolean canUseCommandFile() {
        return true;
    }

    private static void configureTool(TargetedPlatformToolChain toolChain, String tool, Action<List<String>> config) {
        CommandLineToolConfiguration cppCompiler = (CommandLineToolConfiguration)toolChain.getByName(tool);
        cppCompiler.withArguments(config);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultTargetPlatformConfiguration
    implements TargetPlatformConfiguration {
        private final Collection<String> platformNames;
        private Action<? super TargetedPlatformToolChain> configurationAction;

        public DefaultTargetPlatformConfiguration(Collection<String> targetPlatformNames, Action<? super TargetedPlatformToolChain> configurationAction) {
            this.platformNames = targetPlatformNames;
            this.configurationAction = configurationAction;
        }

        @Override
        public boolean supportsPlatform(Platform targetPlatform) {
            return this.platformNames.contains(targetPlatform.getName());
        }

        @Override
        public TargetedPlatformToolChain apply(TargetedPlatformToolChain targetedPlatformToolChain) {
            this.configurationAction.execute((Object)targetedPlatformToolChain);
            return targetedPlatformToolChain;
        }
    }

    private static class Intel64Architecture
    implements TargetPlatformConfiguration {
        private Intel64Architecture() {
        }

        public boolean supportsPlatform(Platform targetPlatform) {
            return targetPlatform.getOperatingSystem().isCurrent() && !OperatingSystem.current().isWindows() && ((ArchitectureInternal)targetPlatform.getArchitecture()).isAmd64();
        }

        public TargetedPlatformToolChain apply(TargetedPlatformToolChain targetedPlatformToolChain) {
            Action<TargetedPlatformToolChain> action = new Action<TargetedPlatformToolChain>(){

                public void execute(TargetedPlatformToolChain configurableToolChain) {
                    Action<List<String>> m64args = new Action<List<String>>(){

                        public void execute(List<String> args) {
                            args.add("-m64");
                        }
                    };
                    AbstractGccCompatibleToolChain.configureTool(configurableToolChain, "cppCompiler", (Action<List<String>>)((Action)m64args));
                    AbstractGccCompatibleToolChain.configureTool(configurableToolChain, "cCompiler", (Action<List<String>>)((Action)m64args));
                    AbstractGccCompatibleToolChain.configureTool(configurableToolChain, "objcCompiler", (Action<List<String>>)((Action)m64args));
                    AbstractGccCompatibleToolChain.configureTool(configurableToolChain, "objcppCompiler", (Action<List<String>>)((Action)m64args));
                    AbstractGccCompatibleToolChain.configureTool(configurableToolChain, "linker", (Action<List<String>>)((Action)m64args));
                    AbstractGccCompatibleToolChain.configureTool(configurableToolChain, "assembler", (Action<List<String>>)((Action)new Action<List<String>>(){

                        public void execute(List<String> args) {
                            if (OperatingSystem.current().isMacOsX()) {
                                args.addAll(Arrays.asList("-arch", "x86_64"));
                            } else {
                                args.add("--64");
                            }
                        }
                    }));
                }
            };
            action.execute((Object)targetedPlatformToolChain);
            return targetedPlatformToolChain;
        }
    }

    private static class Intel32Architecture
    implements TargetPlatformConfiguration {
        private Intel32Architecture() {
        }

        public boolean supportsPlatform(Platform targetPlatform) {
            return targetPlatform.getOperatingSystem().isCurrent() && ((ArchitectureInternal)targetPlatform.getArchitecture()).isI386();
        }

        public TargetedPlatformToolChain apply(TargetedPlatformToolChain targetedPlatformToolChain) {
            Action<TargetedPlatformToolChain> action = new Action<TargetedPlatformToolChain>(){

                public void execute(TargetedPlatformToolChain configurableToolChain) {
                    Action<List<String>> m32args = new Action<List<String>>(){

                        public void execute(List<String> args) {
                            args.add("-m32");
                        }
                    };
                    AbstractGccCompatibleToolChain.configureTool(configurableToolChain, "cppCompiler", (Action<List<String>>)((Action)m32args));
                    AbstractGccCompatibleToolChain.configureTool(configurableToolChain, "cCompiler", (Action<List<String>>)((Action)m32args));
                    AbstractGccCompatibleToolChain.configureTool(configurableToolChain, "objcCompiler", (Action<List<String>>)((Action)m32args));
                    AbstractGccCompatibleToolChain.configureTool(configurableToolChain, "objcppCompiler", (Action<List<String>>)((Action)m32args));
                    AbstractGccCompatibleToolChain.configureTool(configurableToolChain, "linker", (Action<List<String>>)((Action)m32args));
                    AbstractGccCompatibleToolChain.configureTool(configurableToolChain, "assembler", (Action<List<String>>)((Action)new Action<List<String>>(){

                        public void execute(List<String> args) {
                            if (OperatingSystem.current().isMacOsX()) {
                                args.addAll(Arrays.asList("-arch", "i386"));
                            } else {
                                args.add("--32");
                            }
                        }
                    }));
                }
            };
            action.execute((Object)targetedPlatformToolChain);
            return targetedPlatformToolChain;
        }
    }

    private static class ToolChainDefaultArchitecture
    implements TargetPlatformConfiguration {
        private ToolChainDefaultArchitecture() {
        }

        public boolean supportsPlatform(Platform targetPlatform) {
            return targetPlatform.getOperatingSystem().isCurrent() && targetPlatform.getArchitecture() == ArchitectureInternal.TOOL_CHAIN_DEFAULT;
        }

        public TargetedPlatformToolChain apply(TargetedPlatformToolChain targetedPlatformToolChain) {
            return targetedPlatformToolChain;
        }
    }
}

