/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.toolchain.internal;

import java.io.File;
import org.gradle.api.internal.DefaultNamedDomainObjectSet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativebinaries.toolchain.CommandLineToolConfiguration;
import org.gradle.nativebinaries.toolchain.internal.ToolChainInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtendableToolChain<T extends CommandLineToolConfiguration>
extends DefaultNamedDomainObjectSet<T>
implements ToolChainInternal {
    private final String name;
    protected final OperatingSystem operatingSystem;
    private final FileResolver fileResolver;

    protected ExtendableToolChain(Class<? extends T> type, String name, OperatingSystem operatingSystem, FileResolver fileResolver, Instantiator instantiator) {
        super(type, instantiator);
        this.name = name;
        this.operatingSystem = operatingSystem;
        this.fileResolver = fileResolver;
    }

    public String getName() {
        return this.name;
    }

    protected abstract String getTypeName();

    @Override
    public String getDisplayName() {
        return String.format("Tool chain '%s' (%s)", this.getName(), this.getTypeName());
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getOutputType() {
        return String.format("%s-%s", this.getName(), this.operatingSystem.getName());
    }

    @Override
    public String getExecutableName(String executablePath) {
        return this.operatingSystem.getExecutableName(executablePath);
    }

    @Override
    public String getSharedLibraryName(String libraryName) {
        return this.operatingSystem.getSharedLibraryName(libraryName);
    }

    @Override
    public String getSharedLibraryLinkFileName(String libraryName) {
        return this.getSharedLibraryName(libraryName);
    }

    @Override
    public String getStaticLibraryName(String libraryName) {
        return this.operatingSystem.getStaticLibraryName(libraryName);
    }

    protected File resolve(Object path) {
        return this.fileResolver.resolve(path);
    }
}

