/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.test.plugins;

import java.io.File;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.DependentSourceSet;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.RuleSource;
import org.gradle.nativebinaries.NativeBinarySpec;
import org.gradle.nativebinaries.internal.NativeBinarySpecInternal;
import org.gradle.nativebinaries.plugins.NativeComponentPlugin;
import org.gradle.nativebinaries.tasks.InstallExecutable;
import org.gradle.nativebinaries.test.NativeTestSuiteBinarySpec;
import org.gradle.nativebinaries.test.TestSuiteContainer;
import org.gradle.nativebinaries.test.internal.DefaultTestSuiteContainer;
import org.gradle.nativebinaries.test.tasks.RunTestExecutable;
import org.gradle.runtime.base.BinaryContainer;
import org.gradle.runtime.base.internal.BinaryNamingScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class NativeBinariesTestPlugin
implements Plugin<ProjectInternal> {
    public void apply(ProjectInternal project) {
        project.getPlugins().apply(NativeComponentPlugin.class);
    }

    @RuleSource
    public static class Rules {
        @Model
        TestSuiteContainer testSuites(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (TestSuiteContainer)instantiator.newInstance(DefaultTestSuiteContainer.class, new Object[]{instantiator});
        }

        @Finalize
        void attachTestedBinarySourcesToTestBinaries(BinaryContainer binaries) {
            for (NativeTestSuiteBinarySpec testSuiteBinary : binaries.withType(NativeTestSuiteBinarySpec.class)) {
                NativeBinarySpec testedBinary = testSuiteBinary.getTestedBinary();
                testSuiteBinary.source(testedBinary.getSource());
                for (DependentSourceSet testSource : testSuiteBinary.getSource().withType(DependentSourceSet.class)) {
                    testSource.lib(testedBinary.getSource());
                }
            }
        }

        @Finalize
        public void createTestTasks(TaskContainer tasks, BinaryContainer binaries) {
            for (NativeTestSuiteBinarySpec testBinary : binaries.withType(NativeTestSuiteBinarySpec.class)) {
                NativeBinarySpecInternal binary = (NativeBinarySpecInternal)((Object)testBinary);
                BinaryNamingScheme namingScheme = binary.getNamingScheme();
                RunTestExecutable runTask = (RunTestExecutable)tasks.create(namingScheme.getTaskName("run"), RunTestExecutable.class);
                Project project = runTask.getProject();
                runTask.setDescription(String.format("Runs the %s", binary.getNamingScheme().getDescription()));
                InstallExecutable installTask = (InstallExecutable)((Object)binary.getTasks().withType(InstallExecutable.class).iterator().next());
                runTask.getInputs().files(new Object[]{installTask.getOutputs().getFiles()});
                runTask.setExecutable(installTask.getRunScript().getPath());
                runTask.setOutputDir(new File(project.getBuildDir(), "/test-results/" + namingScheme.getOutputDirectoryBase()));
            }
        }
    }
}

