/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.test.cunit.plugins;

import java.io.File;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.c.CSourceSet;
import org.gradle.language.c.plugins.CLangPlugin;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.nativebinaries.NativeBinarySpec;
import org.gradle.nativebinaries.NativeComponentSpec;
import org.gradle.nativebinaries.internal.NativeBinarySpecInternal;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;
import org.gradle.nativebinaries.language.internal.DefaultPreprocessingTool;
import org.gradle.nativebinaries.test.TestSuiteContainer;
import org.gradle.nativebinaries.test.cunit.CUnitTestSuiteBinarySpec;
import org.gradle.nativebinaries.test.cunit.CUnitTestSuiteSpec;
import org.gradle.nativebinaries.test.cunit.internal.DefaultCUnitTestSuiteBinary;
import org.gradle.nativebinaries.test.cunit.internal.DefaultCUnitTestSuiteSpec;
import org.gradle.nativebinaries.test.cunit.tasks.GenerateCUnitLauncher;
import org.gradle.nativebinaries.test.plugins.NativeBinariesTestPlugin;
import org.gradle.nativebinaries.toolchain.internal.ToolChainInternal;
import org.gradle.runtime.base.BinaryContainer;
import org.gradle.runtime.base.internal.BinaryNamingScheme;
import org.gradle.runtime.base.internal.ComponentSpecInternal;
import org.gradle.runtime.base.internal.DefaultBinaryNamingSchemeBuilder;
import org.gradle.runtime.base.internal.DefaultComponentSpecIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class CUnitPlugin
implements Plugin<ProjectInternal> {
    public void apply(ProjectInternal project) {
        project.getPlugins().apply(NativeBinariesTestPlugin.class);
        project.getPlugins().apply(CLangPlugin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RuleSource
    public static class Rules {
        private static final String CUNIT_LAUNCHER_SOURCE_SET = "cunitLauncher";

        @Mutate
        public void createCUnitTestSuitePerComponent(TestSuiteContainer testSuites, NamedDomainObjectSet<NativeComponentSpec> components, ProjectSourceSet projectSourceSet, ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            for (NativeComponentSpec component : components) {
                testSuites.add(this.createCUnitTestSuite(component, instantiator, projectSourceSet));
            }
        }

        private CUnitTestSuiteSpec createCUnitTestSuite(NativeComponentSpec testedComponent, Instantiator instantiator, ProjectSourceSet projectSourceSet) {
            String suiteName = String.format("%sTest", testedComponent.getName());
            String path = testedComponent.getProjectPath();
            DefaultComponentSpecIdentifier id = new DefaultComponentSpecIdentifier(path, suiteName);
            FunctionalSourceSet testSuiteSourceSet = (FunctionalSourceSet)projectSourceSet.maybeCreate(suiteName);
            return (CUnitTestSuiteSpec)instantiator.newInstance(DefaultCUnitTestSuiteSpec.class, new Object[]{id, testedComponent, testSuiteSourceSet});
        }

        @Mutate
        public void configureCUnitTestSuiteSources(ProjectSourceSet projectSourceSet, TestSuiteContainer testSuites, @Path(value="buildDir") File buildDir) {
            for (CUnitTestSuiteSpec suite : testSuites.withType(CUnitTestSuiteSpec.class)) {
                FunctionalSourceSet suiteSourceSet = ((ComponentSpecInternal)suite).getMainSource();
                CSourceSet launcherSources = (CSourceSet)suiteSourceSet.maybeCreate(CUNIT_LAUNCHER_SOURCE_SET, CSourceSet.class);
                File baseDir = new File(buildDir, String.format("src/%s/cunitLauncher", suite.getName()));
                launcherSources.getSource().srcDir((Object)new File(baseDir, "c"));
                launcherSources.getExportedHeaders().srcDir((Object)new File(baseDir, "headers"));
                CSourceSet testSources = (CSourceSet)suiteSourceSet.maybeCreate("c", CSourceSet.class);
                testSources.lib(launcherSources);
            }
        }

        @Mutate
        public void createCUnitLauncherTasks(TaskContainer tasks, TestSuiteContainer testSuites, ProjectSourceSet sources) {
            for (CUnitTestSuiteSpec suite : testSuites.withType(CUnitTestSuiteSpec.class)) {
                String taskName = suite.getName() + "CUnitLauncher";
                GenerateCUnitLauncher skeletonTask = (GenerateCUnitLauncher)tasks.create(taskName, GenerateCUnitLauncher.class);
                CSourceSet launcherSources = this.findLaucherSources(suite);
                skeletonTask.setSourceDir((File)launcherSources.getSource().getSrcDirs().iterator().next());
                skeletonTask.setHeaderDir((File)launcherSources.getExportedHeaders().getSrcDirs().iterator().next());
                launcherSources.builtBy(new Object[]{skeletonTask});
            }
        }

        private CSourceSet findLaucherSources(CUnitTestSuiteSpec suite) {
            return (CSourceSet)suite.getSource().withType(CSourceSet.class).matching((Spec)new Spec<CSourceSet>(){

                public boolean isSatisfiedBy(CSourceSet element) {
                    return element.getName().equals(Rules.CUNIT_LAUNCHER_SOURCE_SET);
                }
            }).iterator().next();
        }

        @Mutate
        public void createCUnitTestBinaries(BinaryContainer binaries, TestSuiteContainer testSuites, @Path(value="buildDir") File buildDir, ServiceRegistry serviceRegistry) {
            for (CUnitTestSuiteSpec cUnitTestSuite : testSuites.withType(CUnitTestSuiteSpec.class)) {
                for (NativeBinarySpec testedBinary : cUnitTestSuite.getTestedComponent().getBinaries()) {
                    CUnitTestSuiteBinarySpec testBinary = this.createTestBinary(serviceRegistry, cUnitTestSuite, testedBinary);
                    this.configure(testBinary, buildDir);
                    cUnitTestSuite.getBinaries().add((Object)testBinary);
                    binaries.add((Object)testBinary);
                }
            }
        }

        private CUnitTestSuiteBinarySpec createTestBinary(ServiceRegistry serviceRegistry, CUnitTestSuiteSpec cUnitTestSuite, NativeBinarySpec testedBinary) {
            BinaryNamingScheme namingScheme = new DefaultBinaryNamingSchemeBuilder(((NativeBinarySpecInternal)testedBinary).getNamingScheme()).withComponentName(cUnitTestSuite.getBaseName()).withTypeString("CUnitExe").build();
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            NativeDependencyResolver resolver = (NativeDependencyResolver)serviceRegistry.get(NativeDependencyResolver.class);
            return (CUnitTestSuiteBinarySpec)instantiator.newInstance(DefaultCUnitTestSuiteBinary.class, new Object[]{cUnitTestSuite, testedBinary, namingScheme, resolver});
        }

        private void configure(CUnitTestSuiteBinarySpec testBinary, File buildDir) {
            BinaryNamingScheme namingScheme = ((NativeBinarySpecInternal)((Object)testBinary)).getNamingScheme();
            File binaryOutputDir = new File(new File(buildDir, "binaries"), namingScheme.getOutputDirectoryBase());
            String baseName = testBinary.getComponent().getBaseName();
            ToolChainInternal tc = (ToolChainInternal)testBinary.getToolChain();
            testBinary.setExecutableFile(new File(binaryOutputDir, tc.getExecutableName(baseName)));
            ((ExtensionAware)testBinary).getExtensions().create("cCompiler", DefaultPreprocessingTool.class, new Object[0]);
        }
    }
}

