/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.plugins;

import java.io.File;
import java.util.Collection;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.internal.Actions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.HeaderExportingSourceSet;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.LanguageRegistry;
import org.gradle.language.base.internal.LanguageSourceSetInternal;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.Finalize;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.nativebinaries.BuildType;
import org.gradle.nativebinaries.BuildTypeContainer;
import org.gradle.nativebinaries.Flavor;
import org.gradle.nativebinaries.FlavorContainer;
import org.gradle.nativebinaries.NativeBinarySpec;
import org.gradle.nativebinaries.NativeComponentSpec;
import org.gradle.nativebinaries.NativeExecutableSpec;
import org.gradle.nativebinaries.NativeLibrarySpec;
import org.gradle.nativebinaries.internal.DefaultBuildTypeContainer;
import org.gradle.nativebinaries.internal.DefaultFlavorContainer;
import org.gradle.nativebinaries.internal.NativeBinarySpecInternal;
import org.gradle.nativebinaries.internal.NativeExecutableSpecFactory;
import org.gradle.nativebinaries.internal.NativeLibrarySpecFactory;
import org.gradle.nativebinaries.internal.configure.DefaultNativeBinariesFactory;
import org.gradle.nativebinaries.internal.configure.DefaultNativeComponentExtension;
import org.gradle.nativebinaries.internal.configure.NativeBinarySpecInitializer;
import org.gradle.nativebinaries.internal.configure.NativeComponentSpecInitializer;
import org.gradle.nativebinaries.internal.configure.RepositoriesFactory;
import org.gradle.nativebinaries.internal.configure.ToolSettingNativeBinaryInitializer;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.nativebinaries.platform.PlatformContainer;
import org.gradle.nativebinaries.platform.internal.DefaultPlatformContainer;
import org.gradle.nativebinaries.toolchain.internal.DefaultToolChainRegistry;
import org.gradle.nativebinaries.toolchain.internal.ToolChainInternal;
import org.gradle.nativebinaries.toolchain.internal.ToolChainRegistryInternal;
import org.gradle.runtime.base.BinaryContainer;
import org.gradle.runtime.base.ComponentSpecContainer;
import org.gradle.runtime.base.internal.BinaryNamingSchemeBuilder;
import org.gradle.runtime.base.internal.DefaultBinaryNamingSchemeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class NativeComponentModelPlugin
implements Plugin<ProjectInternal> {
    private final Instantiator instantiator;
    private final FileResolver fileResolver;

    @Inject
    public NativeComponentModelPlugin(Instantiator instantiator, FileResolver fileResolver) {
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
    }

    public void apply(ProjectInternal project) {
        project.getPlugins().apply(ComponentModelBasePlugin.class);
        project.getModelRegistry().create((ModelCreator)new RepositoriesFactory("repositories", this.instantiator, this.fileResolver));
        ProjectSourceSet sources = (ProjectSourceSet)project.getExtensions().getByType(ProjectSourceSet.class);
        ComponentSpecContainer components = (ComponentSpecContainer)project.getExtensions().getByType(ComponentSpecContainer.class);
        components.registerFactory(NativeExecutableSpec.class, (NamedDomainObjectFactory)new NativeExecutableSpecFactory(this.instantiator, sources, (Project)project));
        NamedDomainObjectContainer nativeExecutables = components.containerWithType(NativeExecutableSpec.class);
        components.registerFactory(NativeLibrarySpec.class, (NamedDomainObjectFactory)new NativeLibrarySpecFactory(this.instantiator, sources, (Project)project));
        NamedDomainObjectContainer nativeLibraries = components.containerWithType(NativeLibrarySpec.class);
        project.getExtensions().create("nativeRuntime", DefaultNativeComponentExtension.class, new Object[]{nativeExecutables, nativeLibraries});
        project.getExtensions().add("nativeComponents", (Object)components.withType(NativeComponentSpec.class));
        project.getExtensions().add("executables", (Object)nativeExecutables);
        project.getExtensions().add("libraries", (Object)nativeLibraries);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MarkBinariesBuildable
    implements Action<NativeBinarySpec> {
        private MarkBinariesBuildable() {
        }

        public void execute(NativeBinarySpec nativeBinarySpec) {
            ToolChainInternal toolChainInternal = (ToolChainInternal)nativeBinarySpec.getToolChain();
            boolean canBuild = toolChainInternal.select(nativeBinarySpec.getTargetPlatform()).isAvailable();
            ((NativeBinarySpecInternal)nativeBinarySpec).setBuildable(canBuild);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RuleSource
    public static class Rules {
        @Model
        ToolChainRegistryInternal toolChains(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (ToolChainRegistryInternal)instantiator.newInstance(DefaultToolChainRegistry.class, new Object[]{instantiator});
        }

        @Model
        PlatformContainer platforms(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (PlatformContainer)instantiator.newInstance(DefaultPlatformContainer.class, new Object[]{instantiator});
        }

        @Model
        BuildTypeContainer buildTypes(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (BuildTypeContainer)instantiator.newInstance(DefaultBuildTypeContainer.class, new Object[]{instantiator});
        }

        @Model
        FlavorContainer flavors(ServiceRegistry serviceRegistry) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            return (FlavorContainer)instantiator.newInstance(DefaultFlavorContainer.class, new Object[]{instantiator});
        }

        @Model
        NamedDomainObjectSet<NativeComponentSpec> nativeComponents(ComponentSpecContainer components) {
            return components.withType(NativeComponentSpec.class);
        }

        @Mutate
        public void registerExtensions(ExtensionContainer extensions, PlatformContainer platforms, BuildTypeContainer buildTypes, FlavorContainer flavors) {
            extensions.add("platforms", (Object)platforms);
            extensions.add("buildTypes", (Object)buildTypes);
            extensions.add("flavors", (Object)flavors);
        }

        @Mutate
        public void createNativeBinaries(BinaryContainer binaries, NamedDomainObjectSet<NativeComponentSpec> nativeComponents, LanguageRegistry languages, ToolChainRegistryInternal toolChains, PlatformContainer platforms, BuildTypeContainer buildTypes, FlavorContainer flavors, ServiceRegistry serviceRegistry, @Path(value="buildDir") File buildDir) {
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            NativeDependencyResolver resolver = (NativeDependencyResolver)serviceRegistry.get(NativeDependencyResolver.class);
            NativeBinarySpecInitializer configureBinaryAction = new NativeBinarySpecInitializer(buildDir);
            ToolSettingNativeBinaryInitializer setToolsAction = new ToolSettingNativeBinaryInitializer(languages);
            Action initAction = Actions.composite((Action[])new Action[]{configureBinaryAction, setToolsAction, new MarkBinariesBuildable()});
            DefaultNativeBinariesFactory factory = new DefaultNativeBinariesFactory(instantiator, (Action<NativeBinarySpec>)initAction, resolver);
            DefaultBinaryNamingSchemeBuilder namingSchemeBuilder = new DefaultBinaryNamingSchemeBuilder();
            NativeComponentSpecInitializer createBinariesAction = new NativeComponentSpecInitializer(factory, (BinaryNamingSchemeBuilder)namingSchemeBuilder, toolChains, (Collection<? extends Platform>)((Object)platforms), (Collection<? extends BuildType>)((Object)buildTypes), (Collection<? extends Flavor>)((Object)flavors));
            for (NativeComponentSpec component : nativeComponents) {
                createBinariesAction.execute(component);
                binaries.addAll(component.getBinaries());
            }
        }

        @Finalize
        public void createDefaultToolChain(ToolChainRegistryInternal toolChains) {
            if (toolChains.isEmpty()) {
                toolChains.addDefaultToolChains();
            }
        }

        @Finalize
        public void createDefaultPlatforms(PlatformContainer platforms) {
            if (platforms.isEmpty()) {
                platforms.create("current");
            }
        }

        @Finalize
        public void createDefaultPlatforms(BuildTypeContainer buildTypes) {
            if (buildTypes.isEmpty()) {
                buildTypes.create("debug");
            }
        }

        @Finalize
        public void createDefaultFlavor(FlavorContainer flavors) {
            if (flavors.isEmpty()) {
                flavors.create("default");
            }
        }

        @Mutate
        void configureGeneratedSourceSets(ProjectSourceSet sources) {
            for (FunctionalSourceSet functionalSourceSet : sources) {
                for (LanguageSourceSetInternal languageSourceSet : functionalSourceSet.withType(LanguageSourceSetInternal.class)) {
                    Task generatorTask = languageSourceSet.getGeneratorTask();
                    if (generatorTask == null) continue;
                    languageSourceSet.builtBy(new Object[]{generatorTask});
                    this.maybeSetSourceDir(languageSourceSet.getSource(), generatorTask, "sourceDir");
                    if (!(languageSourceSet instanceof HeaderExportingSourceSet)) continue;
                    this.maybeSetSourceDir(((HeaderExportingSourceSet)languageSourceSet).getExportedHeaders(), generatorTask, "headerDir");
                }
            }
        }

        @Finalize
        public void applyHeaderSourceSetConventions(ProjectSourceSet sources) {
            for (FunctionalSourceSet functionalSourceSet : sources) {
                for (HeaderExportingSourceSet headerSourceSet : functionalSourceSet.withType(HeaderExportingSourceSet.class)) {
                    if (headerSourceSet.getExportedHeaders().getSrcDirs().isEmpty()) {
                        headerSourceSet.getExportedHeaders().srcDir((Object)String.format("src/%s/headers", functionalSourceSet.getName()));
                    }
                    headerSourceSet.getImplicitHeaders().setSrcDirs((Iterable)headerSourceSet.getSource().getSrcDirs());
                    headerSourceSet.getImplicitHeaders().include(new String[]{"**/*.h"});
                }
            }
        }

        private void maybeSetSourceDir(SourceDirectorySet sourceSet, Task task, String propertyName) {
            Object value = task.property(propertyName);
            if (value != null) {
                sourceSet.srcDir(value);
            }
        }
    }
}

