/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.language.c.internal.incremental.sourceparser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.gradle.api.UncheckedIOException;
import org.gradle.nativebinaries.language.c.internal.incremental.sourceparser.CSourceParser;
import org.gradle.nativebinaries.language.c.internal.incremental.sourceparser.PreprocessingReader;

public class RegexBackedCSourceParser
implements CSourceParser {
    private static final String INCLUDE_IMPORT_PATTERN = "#\\s*(include|import)\\s+((<[^>]+>)|(\"[^\"]+\")|(\\w+))";
    private final Pattern includePattern = Pattern.compile("#\\s*(include|import)\\s+((<[^>]+>)|(\"[^\"]+\")|(\\w+))", 2);

    public CSourceParser.SourceDetails parseSource(File sourceFile) {
        DefaultSourceDetails sourceDetails = new DefaultSourceDetails();
        this.parseFile(sourceFile, sourceDetails);
        return sourceDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(File file, DefaultSourceDetails sourceDetails) {
        try {
            BufferedReader bf = new BufferedReader((Reader)((Object)new PreprocessingReader(new BufferedReader(new FileReader(file)))));
            try {
                String line;
                while ((line = bf.readLine()) != null) {
                    Matcher m = this.includePattern.matcher(line.trim());
                    if (!m.matches()) continue;
                    boolean isImport = "import".equals(m.group(1));
                    String value = m.group(2);
                    if (isImport) {
                        sourceDetails.getImports().add(value);
                        continue;
                    }
                    sourceDetails.getIncludes().add(value);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)bf);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultSourceDetails
    implements CSourceParser.SourceDetails {
        private final List<String> includes = new ArrayList<String>();
        private final List<String> imports = new ArrayList<String>();

        private DefaultSourceDetails() {
        }

        @Override
        public List<String> getIncludes() {
            return this.includes;
        }

        @Override
        public List<String> getImports() {
            return this.imports;
        }
    }
}

