/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.resolve;

import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.nativebinaries.NativeBinarySpec;
import org.gradle.nativebinaries.NativeLibraryBinary;
import org.gradle.nativebinaries.NativeLibraryRequirement;
import org.gradle.nativebinaries.NativeLibrarySpec;
import org.gradle.nativebinaries.internal.resolve.LibraryBinaryLocator;
import org.gradle.nativebinaries.internal.resolve.LibraryResolveException;
import org.gradle.nativebinaries.internal.resolve.ProjectLocator;
import org.gradle.runtime.base.ComponentSpecContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLibraryBinaryLocator
implements LibraryBinaryLocator {
    private final ProjectLocator projectLocator;

    public ProjectLibraryBinaryLocator(ProjectLocator projectLocator) {
        this.projectLocator = projectLocator;
    }

    @Override
    public DomainObjectSet<NativeLibraryBinary> getBinaries(NativeLibraryRequirement requirement) {
        Project project = this.findProject(requirement);
        ComponentSpecContainer componentSpecContainer = (ComponentSpecContainer)project.getExtensions().findByType(ComponentSpecContainer.class);
        if (componentSpecContainer == null) {
            throw new LibraryResolveException(String.format("Project does not have a libraries container: '%s'", project.getPath()));
        }
        DomainObjectSet projectBinaries = ((NativeLibrarySpec)componentSpecContainer.withType(NativeLibrarySpec.class).getByName(requirement.getLibraryName())).getBinaries();
        DefaultDomainObjectSet binaries = new DefaultDomainObjectSet(NativeLibraryBinary.class);
        for (NativeBinarySpec nativeBinarySpec : projectBinaries) {
            binaries.add((Object)((NativeLibraryBinary)((Object)nativeBinarySpec)));
        }
        return binaries;
    }

    private Project findProject(NativeLibraryRequirement requirement) {
        return this.projectLocator.locateProject(requirement.getProjectPath());
    }
}

