/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.prebuilt;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativebinaries.BuildType;
import org.gradle.nativebinaries.Flavor;
import org.gradle.nativebinaries.NativeLibraryBinary;
import org.gradle.nativebinaries.PrebuiltLibrary;
import org.gradle.nativebinaries.internal.prebuilt.DefaultPrebuiltSharedLibraryBinary;
import org.gradle.nativebinaries.internal.prebuilt.DefaultPrebuiltStaticLibraryBinary;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.runtime.base.internal.BinaryNamingSchemeBuilder;
import org.gradle.runtime.base.internal.DefaultBinaryNamingSchemeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrebuiltLibraryInitializer
implements Action<PrebuiltLibrary> {
    private final Instantiator instantiator;
    private final Set<Platform> allPlatforms = new LinkedHashSet<Platform>();
    private final Set<BuildType> allBuildTypes = new LinkedHashSet<BuildType>();
    private final Set<Flavor> allFlavors = new LinkedHashSet<Flavor>();

    public PrebuiltLibraryInitializer(Instantiator instantiator, Collection<? extends Platform> allPlatforms, Collection<? extends BuildType> allBuildTypes, Collection<? extends Flavor> allFlavors) {
        this.instantiator = instantiator;
        this.allPlatforms.addAll(allPlatforms);
        this.allBuildTypes.addAll(allBuildTypes);
        this.allFlavors.addAll(allFlavors);
    }

    public void execute(PrebuiltLibrary prebuiltLibrary) {
        for (Platform platform : this.allPlatforms) {
            for (BuildType buildType : this.allBuildTypes) {
                for (Flavor flavor : this.allFlavors) {
                    this.createNativeBinaries(prebuiltLibrary, platform, buildType, flavor);
                }
            }
        }
    }

    public void createNativeBinaries(PrebuiltLibrary library, Platform platform, BuildType buildType, Flavor flavor) {
        this.createNativeBinary(DefaultPrebuiltSharedLibraryBinary.class, library, platform, buildType, flavor);
        this.createNativeBinary(DefaultPrebuiltStaticLibraryBinary.class, library, platform, buildType, flavor);
    }

    public <T extends NativeLibraryBinary> void createNativeBinary(Class<T> type, PrebuiltLibrary library, Platform platform, BuildType buildType, Flavor flavor) {
        String name = this.getName(type, library, platform, buildType, flavor);
        NativeLibraryBinary nativeBinary = (NativeLibraryBinary)this.instantiator.newInstance(type, new Object[]{name, library, buildType, platform, flavor});
        library.getBinaries().add((Object)nativeBinary);
    }

    private <T extends NativeLibraryBinary> String getName(Class<T> type, PrebuiltLibrary library, Platform platform, BuildType buildType, Flavor flavor) {
        BinaryNamingSchemeBuilder namingScheme = new DefaultBinaryNamingSchemeBuilder().withComponentName(library.getName()).withTypeString(type.getSimpleName()).withVariantDimension(platform.getName()).withVariantDimension(buildType.getName()).withVariantDimension(flavor.getName());
        return namingScheme.build().getLifecycleTaskName();
    }
}

