/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.configure;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Namer;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.internal.DefaultPolymorphicDomainObjectContainer;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.core.Inputs;
import org.gradle.model.internal.core.InstanceModelAdapter;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelCreator;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelType;
import org.gradle.model.internal.core.SingleTypeModelPromise;
import org.gradle.model.internal.core.rule.describe.MethodModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.nativebinaries.BuildType;
import org.gradle.nativebinaries.BuildTypeContainer;
import org.gradle.nativebinaries.Flavor;
import org.gradle.nativebinaries.FlavorContainer;
import org.gradle.nativebinaries.PrebuiltLibraries;
import org.gradle.nativebinaries.PrebuiltLibrary;
import org.gradle.nativebinaries.Repositories;
import org.gradle.nativebinaries.internal.prebuilt.DefaultPrebuiltLibraries;
import org.gradle.nativebinaries.internal.prebuilt.PrebuiltLibraryInitializer;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.nativebinaries.platform.PlatformContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoriesFactory
implements ModelCreator {
    private final ModelPath path;
    private final ModelType<Repositories> type = ModelType.of(Repositories.class);
    private final ModelPromise promise = new SingleTypeModelPromise(this.type);
    private final Instantiator instantiator;
    private final FileResolver fileResolver;
    private final ModelRuleDescriptor descriptor = new MethodModelRuleDescriptor(RepositoriesFactory.findCreateMethod());

    public RepositoriesFactory(String modelPath, Instantiator instantiator, FileResolver fileResolver) {
        this.path = new ModelPath(modelPath);
        this.instantiator = instantiator;
        this.fileResolver = fileResolver;
    }

    public List<ModelReference<?>> getInputs() {
        return ImmutableList.of((Object)ModelReference.of((String)"flavors", FlavorContainer.class), (Object)ModelReference.of((String)"platforms", PlatformContainer.class), (Object)ModelReference.of((String)"buildTypes", BuildTypeContainer.class));
    }

    private static Method findCreateMethod() {
        try {
            return RepositoriesFactory.class.getDeclaredMethod("create", Inputs.class);
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ModelAdapter create(Inputs inputs) {
        FlavorContainer flavors = (FlavorContainer)inputs.get(0, ModelType.of(FlavorContainer.class)).getInstance();
        PlatformContainer platforms = (PlatformContainer)inputs.get(1, ModelType.of(PlatformContainer.class)).getInstance();
        BuildTypeContainer buildTypes = (BuildTypeContainer)inputs.get(2, ModelType.of(BuildTypeContainer.class)).getInstance();
        PrebuiltLibraryInitializer initializer = new PrebuiltLibraryInitializer(this.instantiator, (Collection<? extends Platform>)((Object)platforms), (Collection<? extends BuildType>)((Object)buildTypes), (Collection<? extends Flavor>)((Object)flavors));
        return InstanceModelAdapter.of(this.type, (Object)new DefaultRepositories(this.instantiator, this.fileResolver, initializer));
    }

    public ModelPath getPath() {
        return this.path;
    }

    public ModelPromise getPromise() {
        return this.promise;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArtifactRepositoryNamer
    implements Namer<ArtifactRepository> {
        private ArtifactRepositoryNamer() {
        }

        public String determineName(ArtifactRepository object) {
            return object.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultRepositories
    extends DefaultPolymorphicDomainObjectContainer<ArtifactRepository>
    implements Repositories {
        private DefaultRepositories(final Instantiator instantiator, final FileResolver fileResolver, final Action<PrebuiltLibrary> binaryFactory) {
            super(ArtifactRepository.class, instantiator, (Namer)new ArtifactRepositoryNamer());
            this.registerFactory(PrebuiltLibraries.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<PrebuiltLibraries>(){

                public PrebuiltLibraries create(String name) {
                    return (PrebuiltLibraries)instantiator.newInstance(DefaultPrebuiltLibraries.class, new Object[]{name, instantiator, fileResolver, binaryFactory});
                }
            });
        }
    }
}

