/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.configure;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.nativebinaries.NativeBinarySpec;
import org.gradle.nativebinaries.NativeExecutableBinarySpec;
import org.gradle.nativebinaries.SharedLibraryBinarySpec;
import org.gradle.nativebinaries.StaticLibraryBinarySpec;
import org.gradle.nativebinaries.internal.NativeBinarySpecInternal;
import org.gradle.nativebinaries.toolchain.internal.ToolChainInternal;
import org.gradle.runtime.base.internal.BinaryNamingScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeBinarySpecInitializer
implements Action<NativeBinarySpec> {
    private final File binariesOutputDir;

    public NativeBinarySpecInitializer(File buildDir) {
        this.binariesOutputDir = new File(buildDir, "binaries");
    }

    public void execute(NativeBinarySpec nativeBinary) {
        ToolChainInternal tc = (ToolChainInternal)nativeBinary.getToolChain();
        BinaryNamingScheme namingScheme = ((NativeBinarySpecInternal)nativeBinary).getNamingScheme();
        File binaryOutputDir = new File(this.binariesOutputDir, namingScheme.getOutputDirectoryBase());
        String baseName = nativeBinary.getComponent().getBaseName();
        if (nativeBinary instanceof NativeExecutableBinarySpec) {
            ((NativeExecutableBinarySpec)nativeBinary).setExecutableFile(new File(binaryOutputDir, tc.getExecutableName(baseName)));
        } else if (nativeBinary instanceof SharedLibraryBinarySpec) {
            ((SharedLibraryBinarySpec)nativeBinary).setSharedLibraryFile(new File(binaryOutputDir, tc.getSharedLibraryName(baseName)));
            ((SharedLibraryBinarySpec)nativeBinary).setSharedLibraryLinkFile(new File(binaryOutputDir, tc.getSharedLibraryLinkFileName(baseName)));
        } else if (nativeBinary instanceof StaticLibraryBinarySpec) {
            ((StaticLibraryBinarySpec)nativeBinary).setStaticLibraryFile(new File(binaryOutputDir, tc.getStaticLibraryName(baseName)));
        }
    }
}

