/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal.configure;

import org.gradle.api.Action;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativebinaries.BuildType;
import org.gradle.nativebinaries.Flavor;
import org.gradle.nativebinaries.NativeBinarySpec;
import org.gradle.nativebinaries.NativeComponentSpec;
import org.gradle.nativebinaries.NativeLibrarySpec;
import org.gradle.nativebinaries.internal.DefaultNativeExecutableBinarySpec;
import org.gradle.nativebinaries.internal.DefaultSharedLibraryBinarySpec;
import org.gradle.nativebinaries.internal.DefaultStaticLibraryBinarySpec;
import org.gradle.nativebinaries.internal.configure.NativeBinariesFactory;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.nativebinaries.toolchain.ToolChain;
import org.gradle.runtime.base.internal.BinaryNamingScheme;
import org.gradle.runtime.base.internal.BinaryNamingSchemeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNativeBinariesFactory
implements NativeBinariesFactory {
    private final Instantiator instantiator;
    private final Action<NativeBinarySpec> configureAction;
    private final NativeDependencyResolver resolver;

    public DefaultNativeBinariesFactory(Instantiator instantiator, Action<NativeBinarySpec> configureAction, NativeDependencyResolver resolver) {
        this.configureAction = configureAction;
        this.instantiator = instantiator;
        this.resolver = resolver;
    }

    @Override
    public void createNativeBinaries(NativeComponentSpec component, BinaryNamingSchemeBuilder namingScheme, ToolChain toolChain, Platform platform, BuildType buildType, Flavor flavor) {
        if (component instanceof NativeLibrarySpec) {
            this.createNativeBinary(DefaultSharedLibraryBinarySpec.class, component, namingScheme.withTypeString("SharedLibrary").build(), toolChain, platform, buildType, flavor);
            this.createNativeBinary(DefaultStaticLibraryBinarySpec.class, component, namingScheme.withTypeString("StaticLibrary").build(), toolChain, platform, buildType, flavor);
        } else {
            this.createNativeBinary(DefaultNativeExecutableBinarySpec.class, component, namingScheme.withTypeString("Executable").build(), toolChain, platform, buildType, flavor);
        }
    }

    private void createNativeBinary(Class<? extends NativeBinarySpec> type, NativeComponentSpec component, BinaryNamingScheme namingScheme, ToolChain toolChain, Platform platform, BuildType buildType, Flavor flavor) {
        NativeBinarySpec nativeBinary = (NativeBinarySpec)this.instantiator.newInstance(type, new Object[]{component, flavor, toolChain, platform, buildType, namingScheme, this.resolver});
        this.setupDefaults(nativeBinary);
        component.getBinaries().add((Object)nativeBinary);
    }

    private void setupDefaults(NativeBinarySpec nativeBinary) {
        this.configureAction.execute((Object)nativeBinary);
    }
}

