/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativebinaries.internal;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.language.HeaderExportingSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.nativebinaries.BuildType;
import org.gradle.nativebinaries.Flavor;
import org.gradle.nativebinaries.NativeLibrarySpec;
import org.gradle.nativebinaries.internal.AbstractNativeBinarySpec;
import org.gradle.nativebinaries.internal.resolve.NativeDependencyResolver;
import org.gradle.nativebinaries.platform.Platform;
import org.gradle.nativebinaries.toolchain.internal.ToolChainInternal;
import org.gradle.runtime.base.internal.BinaryNamingScheme;

public abstract class AbstractNativeLibraryBinarySpec
extends AbstractNativeBinarySpec {
    protected AbstractNativeLibraryBinarySpec(NativeLibrarySpec library, Flavor flavor, ToolChainInternal toolChain, Platform targetPlatform, BuildType buildType, BinaryNamingScheme namingScheme, NativeDependencyResolver resolver) {
        super(library, flavor, toolChain, targetPlatform, buildType, namingScheme, resolver);
    }

    protected boolean hasSources() {
        for (LanguageSourceSet sourceSet : this.getSource()) {
            if (!sourceSet.getSource().isEmpty()) {
                return true;
            }
            if (!sourceSet.hasBuildDependencies()) continue;
            return true;
        }
        return false;
    }

    public FileCollection getHeaderDirs() {
        return new AbstractFileCollection(){

            public String getDisplayName() {
                return String.format("Headers for %s", AbstractNativeLibraryBinarySpec.this.getName());
            }

            public Set<File> getFiles() {
                LinkedHashSet<File> headerDirs = new LinkedHashSet<File>();
                for (HeaderExportingSourceSet sourceSet : AbstractNativeLibraryBinarySpec.this.getSource().withType(HeaderExportingSourceSet.class)) {
                    headerDirs.addAll(sourceSet.getExportedHeaders().getSrcDirs());
                }
                return headerDirs;
            }

            public TaskDependency getBuildDependencies() {
                DefaultTaskDependency dependency = new DefaultTaskDependency();
                for (HeaderExportingSourceSet sourceSet : AbstractNativeLibraryBinarySpec.this.getSource().withType(HeaderExportingSourceSet.class)) {
                    dependency.add(new Object[]{sourceSet.getBuildDependencies()});
                }
                return dependency;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class LibraryOutputs
    extends AbstractFileCollection {
        protected LibraryOutputs() {
        }

        public final Set<File> getFiles() {
            if (this.hasOutputs()) {
                return this.getOutputs();
            }
            return Collections.emptySet();
        }

        public final String getDisplayName() {
            return AbstractNativeLibraryBinarySpec.this.toString();
        }

        public final TaskDependency getBuildDependencies() {
            if (this.hasOutputs()) {
                return AbstractNativeLibraryBinarySpec.this.getBuildDependencies();
            }
            return new DefaultTaskDependency();
        }

        protected abstract boolean hasOutputs();

        protected abstract Set<File> getOutputs();
    }
}

