/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.rc.plugins;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.language.base.internal.LanguageRegistry;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.internal.NativeLanguageRegistration;
import org.gradle.language.rc.WindowsResourceSet;
import org.gradle.language.rc.internal.DefaultWindowsResourceSet;
import org.gradle.nativebinaries.NativeBinarySpec;
import org.gradle.nativebinaries.language.internal.DefaultPreprocessingTool;
import org.gradle.nativebinaries.language.internal.WindowsResourcesCompileTaskConfig;
import org.gradle.runtime.base.BinarySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class WindowsResourceScriptPlugin
implements Plugin<ProjectInternal> {
    public void apply(ProjectInternal project) {
        project.getPlugins().apply(ComponentModelBasePlugin.class);
        ((LanguageRegistry)project.getExtensions().getByType(LanguageRegistry.class)).add((Object)new WindowsResources());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WindowsResources
    extends NativeLanguageRegistration<WindowsResourceSet> {
        private WindowsResources() {
        }

        public String getName() {
            return "rc";
        }

        public Class<WindowsResourceSet> getSourceSetType() {
            return WindowsResourceSet.class;
        }

        public Class<? extends WindowsResourceSet> getSourceSetImplementation() {
            return DefaultWindowsResourceSet.class;
        }

        public Map<String, Class<?>> getBinaryTools() {
            LinkedHashMap tools = Maps.newLinkedHashMap();
            tools.put("rcCompiler", DefaultPreprocessingTool.class);
            return tools;
        }

        public SourceTransformTaskConfig getTransformTask() {
            return new WindowsResourcesCompileTaskConfig();
        }

        @Override
        public boolean applyToBinary(BinarySpec binary) {
            return binary instanceof NativeBinarySpec && this.shouldProcessResources((NativeBinarySpec)binary);
        }

        private boolean shouldProcessResources(NativeBinarySpec binary) {
            return binary.getTargetPlatform().getOperatingSystem().isWindows();
        }
    }
}

