/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.ide.visualstudio.VisualStudioExtension;
import org.gradle.ide.visualstudio.internal.VisualStudioExtensionInternal;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfiguration;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectRegistry;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelType;
import org.gradle.nativebinaries.NativeBinarySpec;
import org.gradle.nativebinaries.internal.resolve.ProjectLocator;

public class VisualStudioProjectResolver {
    private final ProjectLocator projectLocator;

    public VisualStudioProjectResolver(ProjectLocator projectLocator) {
        this.projectLocator = projectLocator;
    }

    public VisualStudioProjectConfiguration lookupProjectConfiguration(NativeBinarySpec nativeBinary) {
        ProjectInternal componentProject = this.getComponentProject(nativeBinary);
        VisualStudioExtension visualStudioExtension = (VisualStudioExtension)componentProject.getModelRegistry().get(ModelPath.path((String)"visualStudio"), ModelType.of(VisualStudioExtension.class));
        VisualStudioProjectRegistry projectRegistry = ((VisualStudioExtensionInternal)visualStudioExtension).getProjectRegistry();
        return projectRegistry.getProjectConfiguration(nativeBinary);
    }

    private ProjectInternal getComponentProject(NativeBinarySpec nativeBinary) {
        String projectPath = nativeBinary.getComponent().getProjectPath();
        return this.projectLocator.locateProject(projectPath);
    }
}

