/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.apache.maven.repository.legacy;

import org.gradle.mvn3.org.apache.maven.repository.ArtifactTransferResource;
import org.gradle.mvn3.org.apache.maven.wagon.resource.Resource;

class MavenArtifact
implements ArtifactTransferResource {
    private String repositoryUrl;
    private Resource resource;
    private long transferStartTime;

    public MavenArtifact(String repositoryUrl, Resource resource) {
        this.repositoryUrl = repositoryUrl == null ? "" : (!repositoryUrl.endsWith("/") && repositoryUrl.length() > 0 ? repositoryUrl + '/' : repositoryUrl);
        this.resource = resource;
        this.transferStartTime = System.currentTimeMillis();
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getName() {
        String name = this.resource.getName();
        if (name == null) {
            name = "";
        } else if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    public String getUrl() {
        return this.getRepositoryUrl() + this.getName();
    }

    public long getContentLength() {
        return this.resource.getContentLength();
    }

    public long getTransferStartTime() {
        return this.transferStartTime;
    }

    public String toString() {
        return this.getUrl();
    }
}

