/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.devel.plugins;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.plugins.PluginDescriptor;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.bundling.Jar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JavaGradlePluginPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(JavaGradlePluginPlugin.class);
    static final String COMPILE_CONFIGURATION = "compile";
    static final String JAR_TASK = "jar";
    static final String GRADLE_PLUGINS = "gradle-plugins";
    static final String PLUGIN_DESCRIPTOR_PATTERN = "META-INF/gradle-plugins/*.properties";
    static final String CLASSES_PATTERN = "**/*.class";
    static final String BAD_IMPL_CLASS_WARNING_MESSAGE = "A valid plugin descriptor was found for %s but the implementation class %s was not found in the jar.";
    static final String INVALID_DESCRIPTOR_WARNING_MESSAGE = "A plugin descriptor was found for %s but it was invalid.";
    static final String NO_DESCRIPTOR_WARNING_MESSAGE = "No valid plugin descriptors were found in META-INF/gradle-plugins.";

    public void apply(Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        this.applyDependencies(project);
        this.configureJarTask(project);
    }

    private void applyDependencies(Project project) {
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add(COMPILE_CONFIGURATION, (Object)dependencies.gradleApi());
    }

    private void configureJarTask(Project project) {
        Jar jarTask = (Jar)project.getTasks().findByName(JAR_TASK);
        ArrayList<PluginDescriptor> descriptors = new ArrayList<PluginDescriptor>();
        HashSet<String> classList = new HashSet<String>();
        PluginDescriptorCollectorAction pluginDescriptorCollector = new PluginDescriptorCollectorAction(descriptors);
        ClassManifestCollectorAction classManifestCollector = new ClassManifestCollectorAction(classList);
        PluginValidationAction pluginValidationAction = new PluginValidationAction(descriptors, classList);
        jarTask.filesMatching(PLUGIN_DESCRIPTOR_PATTERN, (Action)pluginDescriptorCollector);
        jarTask.filesMatching(CLASSES_PATTERN, (Action)classManifestCollector);
        jarTask.doLast((Action)pluginValidationAction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassManifestCollectorAction
    implements Action<FileCopyDetails> {
        Set<String> classList;

        ClassManifestCollectorAction(Set<String> classList) {
            this.classList = classList;
        }

        public void execute(FileCopyDetails fileCopyDetails) {
            this.classList.add(fileCopyDetails.getRelativePath().toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PluginDescriptorCollectorAction
    implements Action<FileCopyDetails> {
        List<PluginDescriptor> descriptors;

        PluginDescriptorCollectorAction(List<PluginDescriptor> descriptors) {
            this.descriptors = descriptors;
        }

        public void execute(FileCopyDetails fileCopyDetails) {
            PluginDescriptor descriptor;
            try {
                descriptor = new PluginDescriptor(fileCopyDetails.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                return;
            }
            if (descriptor.getImplementationClassName() != null) {
                this.descriptors.add(descriptor);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PluginValidationAction
    implements Action<Task> {
        Collection<PluginDescriptor> descriptors;
        Set<String> classes;

        PluginValidationAction(Collection<PluginDescriptor> descriptors, Set<String> classes) {
            this.descriptors = descriptors;
            this.classes = classes;
        }

        public void execute(Task task) {
            if (this.descriptors == null || this.descriptors.isEmpty()) {
                LOGGER.warn(JavaGradlePluginPlugin.NO_DESCRIPTOR_WARNING_MESSAGE);
            } else {
                for (PluginDescriptor descriptor : this.descriptors) {
                    URI descriptorURI = null;
                    try {
                        descriptorURI = descriptor.getPropertiesFileUrl().toURI();
                    }
                    catch (URISyntaxException e) {
                        // empty catch block
                    }
                    String pluginFileName = descriptorURI != null ? new File(descriptorURI).getName() : "UNKNOWN";
                    String pluginImplementation = descriptor.getImplementationClassName();
                    if (pluginImplementation.length() == 0) {
                        LOGGER.warn(String.format(JavaGradlePluginPlugin.INVALID_DESCRIPTOR_WARNING_MESSAGE, pluginFileName));
                        continue;
                    }
                    if (this.hasFullyQualifiedClass(pluginImplementation)) continue;
                    LOGGER.warn(String.format(JavaGradlePluginPlugin.BAD_IMPL_CLASS_WARNING_MESSAGE, pluginFileName, pluginImplementation));
                }
            }
        }

        boolean hasFullyQualifiedClass(String fqClass) {
            return this.classes.contains(fqClass.replaceAll("\\.", "/") + ".class");
        }
    }
}

