/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatableInputStreamEntity
extends AbstractHttpEntity {
    private final Factory<InputStream> source;
    private final Long contentLength;

    public RepeatableInputStreamEntity(Factory<InputStream> source, Long contentLength, ContentType contentType) {
        this.source = source;
        this.contentLength = contentLength;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return (InputStream)this.source.create();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        IOUtils.copyLarge((InputStream)this.getContent(), (OutputStream)outstream);
    }

    public boolean isStreaming() {
        return true;
    }
}

