/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.resource.transport.http.HttpProxySettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSystemPropertiesHttpProxySettings
implements HttpProxySettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaSystemPropertiesHttpProxySettings.class);
    private static final int DEFAULT_PROXY_PORT = 80;
    private final HttpProxySettings.HttpProxy proxy;
    private final List<Pattern> nonProxyHosts;

    public JavaSystemPropertiesHttpProxySettings() {
        this(System.getProperty("http.proxyHost"), System.getProperty("http.proxyPort"), System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword"), System.getProperty("http.nonProxyHosts"));
    }

    JavaSystemPropertiesHttpProxySettings(String proxyHost, String proxyPortString, String proxyUser, String proxyPassword, String nonProxyHostsString) {
        this.proxy = StringUtils.isBlank((String)proxyHost) ? null : new HttpProxySettings.HttpProxy(proxyHost, this.initProxyPort(proxyPortString), proxyUser, proxyPassword);
        this.nonProxyHosts = this.initNonProxyHosts(nonProxyHostsString);
    }

    private int initProxyPort(String proxyPortString) {
        if (StringUtils.isBlank((String)proxyPortString)) {
            return 80;
        }
        try {
            return Integer.parseInt(proxyPortString);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid value for java system property 'http.proxyPort': {}. Default port '{}' will be used.", (Object)System.getProperty("http.proxyPort"), (Object)80);
            return 80;
        }
    }

    private List<Pattern> initNonProxyHosts(String nonProxyHostsString) {
        if (StringUtils.isBlank((String)nonProxyHostsString)) {
            return Collections.emptyList();
        }
        LOGGER.debug("Found java system property 'http.nonProxyHosts': {}. Will ignore proxy settings for these hosts.", (Object)nonProxyHostsString);
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String nonProxyHost : nonProxyHostsString.split("\\|")) {
            patterns.add(this.createHostMatcher(nonProxyHost));
        }
        return patterns;
    }

    private Pattern createHostMatcher(String nonProxyHost) {
        if (nonProxyHost.startsWith("*")) {
            return Pattern.compile(".*" + Pattern.quote(nonProxyHost.substring(1)));
        }
        if (nonProxyHost.endsWith("*")) {
            return Pattern.compile(Pattern.quote(nonProxyHost.substring(0, nonProxyHost.length() - 1)) + ".*");
        }
        return Pattern.compile(Pattern.quote(nonProxyHost));
    }

    @Override
    public HttpProxySettings.HttpProxy getProxy() {
        return this.proxy;
    }

    @Override
    public HttpProxySettings.HttpProxy getProxy(String host) {
        if (this.proxy == null || this.isNonProxyHost(host)) {
            return null;
        }
        return this.proxy;
    }

    private boolean isNonProxyHost(String host) {
        for (Pattern nonProxyHost : this.nonProxyHosts) {
            if (!nonProxyHost.matcher(host).matches()) continue;
            return true;
        }
        return false;
    }
}

