/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.util.EntityUtils;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.AbstractExternalResource;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseResource
extends AbstractExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResponseResource.class);
    private final String method;
    private final URI source;
    private final HttpResponse response;
    private final ExternalResourceMetaData metaData;
    private boolean wasOpened;

    public HttpResponseResource(String method, URI source, HttpResponse response) {
        this.method = method;
        this.source = source;
        this.response = response;
        String etag = HttpResponseResource.getEtag(response);
        this.metaData = new DefaultExternalResourceMetaData(source, this.getLastModified(), this.getContentLength(), etag, HttpResponseResource.getSha1(response, etag));
    }

    public URI getURI() {
        return this.source;
    }

    public String toString() {
        return String.format("Http %s Resource: %s", this.method, this.source);
    }

    public ExternalResourceMetaData getMetaData() {
        return this.metaData;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public long getLastModified() {
        Header responseHeader = this.response.getFirstHeader("last-modified");
        if (responseHeader == null) {
            return 0L;
        }
        try {
            return DateUtils.parseDate((String)responseHeader.getValue()).getTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public long getContentLength() {
        Header header = this.response.getFirstHeader("Content-Length");
        if (header == null) {
            return -1L;
        }
        String value = header.getValue();
        if (value == null) {
            return -1L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public String getHeaderValue(String name) {
        Header header = this.response.getFirstHeader(name);
        return header != null ? header.getValue() : null;
    }

    public String getContentType() {
        Header header = this.response.getFirstHeader("Content-Type");
        return header == null ? null : header.getValue();
    }

    public boolean isLocal() {
        return false;
    }

    public InputStream openStream() throws IOException {
        if (this.wasOpened) {
            throw new IOException("Unable to open Stream as it was opened before.");
        }
        LOGGER.debug("Attempting to download resource {}.", (Object)this.source);
        this.wasOpened = true;
        return this.response.getEntity().getContent();
    }

    public void close() throws IOException {
        EntityUtils.consume((HttpEntity)this.response.getEntity());
    }

    private static String getEtag(HttpResponse response) {
        Header etagHeader = response.getFirstHeader("ETag");
        return etagHeader == null ? null : etagHeader.getValue();
    }

    private static HashValue getSha1(HttpResponse response, String etag) {
        Header sha1Header = response.getFirstHeader("X-Checksum-Sha1");
        if (sha1Header != null) {
            return new HashValue(sha1Header.getValue());
        }
        if (etag != null && etag.startsWith("{SHA1{")) {
            String hash = etag.substring(6, etag.length() - 2);
            return new HashValue(hash);
        }
        return null;
    }
}

