/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.internal.batch;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import com.google.common.annotations.VisibleForTesting;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.io.IOUtils;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.Batch;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.runner.internal.batch.SonarProjectBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher {
    private Properties propertiesFromRunner;
    private List<Object> containerExtensions;

    public Launcher(Properties properties, List<Object> containerExtensions) {
        this.propertiesFromRunner = properties;
        this.containerExtensions = containerExtensions;
    }

    public void execute() {
        ProjectDefinition project = SonarProjectBuilder.create(this.propertiesFromRunner).generateProjectDefinition();
        Configuration initialConfiguration = this.getInitialConfiguration(project);
        this.initLogging(initialConfiguration);
        this.executeBatch(project, initialConfiguration);
    }

    private void executeBatch(ProjectDefinition project, Configuration initialConfiguration) {
        this.setContainerExtensionsOnProject(project);
        String envKey = this.propertiesFromRunner.getProperty("sonar.environment.information.key");
        String envVersion = this.propertiesFromRunner.getProperty("sonar.environment.information.version");
        Batch batch = Batch.create((ProjectReactor)new ProjectReactor(project), (Configuration)initialConfiguration, (Object[])new Object[]{new EnvironmentInformation(envKey, envVersion)});
        batch.execute();
    }

    private void setContainerExtensionsOnProject(ProjectDefinition projectDefinition) {
        for (Object extension : this.containerExtensions) {
            projectDefinition.addContainerExtension(extension);
        }
        for (ProjectDefinition module : projectDefinition.getSubProjects()) {
            this.setContainerExtensionsOnProject(module);
        }
    }

    private void initLogging(Configuration initialConfiguration) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)context);
        context.reset();
        InputStream input = Batch.class.getResourceAsStream("/org/sonar/batch/logback.xml");
        System.setProperty("ROOT_LOGGER_LEVEL", this.isDebug() ? "DEBUG" : "INFO");
        context.putProperty("SQL_LOGGER_LEVEL", Launcher.getSqlLevel(initialConfiguration));
        context.putProperty("SQL_RESULTS_LOGGER_LEVEL", Launcher.getSqlResultsLevel(initialConfiguration));
        try {
            jc.doConfigure(input);
        }
        catch (JoranException e) {
            throw new SonarException("can not initialize logging", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    @VisibleForTesting
    protected boolean isDebug() {
        return Boolean.parseBoolean(this.propertiesFromRunner.getProperty("sonar.verbose", this.propertiesFromRunner.getProperty("runner.debug", "false")));
    }

    @VisibleForTesting
    protected static String getSqlLevel(Configuration config) {
        boolean showSql = config.getBoolean("sonar.showSql", false);
        return showSql ? "DEBUG" : "WARN";
    }

    @VisibleForTesting
    protected static String getSqlResultsLevel(Configuration config) {
        boolean showSql = config.getBoolean("sonar.showSqlResults", false);
        return showSql ? "DEBUG" : "WARN";
    }

    private Configuration getInitialConfiguration(ProjectDefinition project) {
        CompositeConfiguration configuration = new CompositeConfiguration();
        configuration.addConfiguration((Configuration)new SystemConfiguration());
        configuration.addConfiguration((Configuration)new EnvironmentConfiguration());
        configuration.addConfiguration((Configuration)new MapConfiguration((Map)project.getProperties()));
        return configuration;
    }
}

