/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.sonar.runner.BootstrapClassLoader;
import org.sonar.runner.Bootstrapper;
import org.sonar.runner.RunnerException;
import org.sonar.runner.Version;

public final class Runner {
    @Deprecated
    public static final String PROPERTY_OLD_DEBUG_MODE = "runner.debug";
    public static final String PROPERTY_VERBOSE = "sonar.verbose";
    public static final String PROPERTY_WORK_DIRECTORY = "sonar.working.directory";
    public static final String DEF_VALUE_WORK_DIRECTORY = ".sonar";
    public static final String PROPERTY_SONAR_PROJECT_BASEDIR = "sonar.projectBaseDir";
    public static final String PROPERTY_ENVIRONMENT_INFORMATION_KEY = "sonar.environment.information.key";
    public static final String PROPERTY_ENVIRONMENT_INFORMATION_VERSION = "sonar.environment.information.version";
    private static final String[] UNSUPPORTED_VERSIONS = new String[]{"1", "2.0", "2.1", "2.2", "2.3", "2.4", "2.5", "2.6", "2.7", "2.8", "2.9", "2.10"};
    private static final String PROPERTY_SOURCE_ENCODING = "sonar.sourceEncoding";
    private File projectDir;
    private File workDir;
    private String[] unmaskedPackages;
    private List<Object> containerExtensions = new ArrayList<Object>();
    private Properties properties;
    private boolean isEncodingPlatformDependant;

    private Runner(Properties props) {
        this.properties = props;
        this.unmaskedPackages = new String[0];
        this.properties.put(PROPERTY_ENVIRONMENT_INFORMATION_KEY, "Runner");
        this.properties.put(PROPERTY_ENVIRONMENT_INFORMATION_VERSION, Version.getVersion());
        if (!this.properties.containsKey(PROPERTY_SOURCE_ENCODING)) {
            this.isEncodingPlatformDependant = true;
            this.properties.setProperty(PROPERTY_SOURCE_ENCODING, Charset.defaultCharset().name());
        }
        this.initDirs();
    }

    public static Runner create(Properties props) {
        return new Runner(props);
    }

    public static Runner create(Properties props, File basedir) {
        props.put(PROPERTY_SONAR_PROJECT_BASEDIR, basedir.getAbsolutePath());
        return new Runner(props);
    }

    public void execute() {
        Bootstrapper bootstrapper = new Bootstrapper("SonarRunner/" + Version.getVersion(), this.getSonarServerURL(), this.getWorkDir());
        this.checkSonarVersion(bootstrapper);
        this.delegateExecution(this.createClassLoader(bootstrapper));
    }

    public String getSonarServerURL() {
        return this.properties.getProperty("sonar.host.url", "http://localhost:9000");
    }

    private void initDirs() {
        String path = this.properties.getProperty(PROPERTY_SONAR_PROJECT_BASEDIR, ".");
        this.projectDir = new File(path);
        if (!this.projectDir.isDirectory()) {
            throw new RunnerException("Project home must be an existing directory: " + path);
        }
        this.properties.put(PROPERTY_SONAR_PROJECT_BASEDIR, this.projectDir.getAbsolutePath());
        this.workDir = this.initWorkDir();
    }

    private File initWorkDir() {
        String customWorkDir = this.properties.getProperty(PROPERTY_WORK_DIRECTORY);
        if (customWorkDir == null || "".equals(customWorkDir.trim())) {
            return new File(this.getProjectDir(), DEF_VALUE_WORK_DIRECTORY);
        }
        return this.defineCustomizedWorkDir(new File(customWorkDir));
    }

    private File defineCustomizedWorkDir(File customWorkDir) {
        if (customWorkDir.isAbsolute()) {
            return customWorkDir;
        }
        return new File(this.getProjectDir(), customWorkDir.getPath());
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public String getSourceCodeEncoding() {
        return this.properties.getProperty(PROPERTY_SOURCE_ENCODING);
    }

    public boolean isEncodingPlatformDependant() {
        return this.isEncodingPlatformDependant;
    }

    protected Properties getProperties() {
        return this.properties;
    }

    protected void checkSonarVersion(Bootstrapper bootstrapper) {
        String serverVersion = bootstrapper.getServerVersion();
        if (Runner.isUnsupportedVersion(serverVersion)) {
            throw new RunnerException("Sonar " + serverVersion + " is not supported. Please upgrade Sonar to version 2.11 or more.");
        }
    }

    private BootstrapClassLoader createClassLoader(Bootstrapper bootstrapper) {
        URL url = Runner.getJarPath();
        return bootstrapper.createClassLoader(new URL[]{url}, this.getClass().getClassLoader(), this.unmaskedPackages);
    }

    public static URL getJarPath() {
        String pathToClass = "/" + Runner.class.getName().replace('.', '/') + ".class";
        URL url = Runner.class.getResource(pathToClass);
        if (url != null) {
            String path = url.toString();
            String uri = null;
            if (path.startsWith("jar:file:")) {
                int bang = path.indexOf(33);
                uri = path.substring(4, bang);
            } else if (path.startsWith("file:")) {
                int tail = path.indexOf(pathToClass);
                uri = path.substring(0, tail);
            }
            if (uri != null) {
                try {
                    return new URL(uri);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    static boolean isUnsupportedVersion(String version) {
        for (String unsupportedVersion : UNSUPPORTED_VERSIONS) {
            if (!Runner.isVersion(version, unsupportedVersion)) continue;
            return true;
        }
        return false;
    }

    static boolean isVersion(String version, String prefix) {
        return version.startsWith(prefix + ".") || version.equals(prefix);
    }

    private void delegateExecution(BootstrapClassLoader sonarClassLoader) {
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(sonarClassLoader);
            Class<?> launcherClass = sonarClassLoader.findClass("org.sonar.runner.internal.batch.Launcher");
            Constructor<?> constructor = launcherClass.getConstructor(Properties.class, List.class);
            Object launcher = constructor.newInstance(this.getProperties(), this.containerExtensions);
            Method method = launcherClass.getMethod("execute", new Class[0]);
            method.invoke(launcher, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RunnerException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
    }

    public void setEnvironmentInformation(String key, String version) {
        this.properties.put(PROPERTY_ENVIRONMENT_INFORMATION_KEY, key);
        this.properties.put(PROPERTY_ENVIRONMENT_INFORMATION_VERSION, version);
    }

    public void setUnmaskedPackages(String ... unmaskedPackages) {
        this.unmaskedPackages = unmaskedPackages;
    }

    public void addContainerExtension(Object extension) {
        this.containerExtensions.add(extension);
    }
}

