/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.artifacts.ModuleInternal;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.ProjectDependencyPublicationResolver;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.artifact.MavenArtifactNotationParserFactory;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenProjectIdentity;
import org.gradle.api.publish.maven.internal.publication.DefaultMavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.publish.maven.tasks.PublishToMavenLocal;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class MavenPublishPlugin
implements Plugin<Project> {
    public static final String PUBLISH_LOCAL_LIFECYCLE_TASK_NAME = "publishToMavenLocal";
    private final Instantiator instantiator;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final FileResolver fileResolver;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;

    @Inject
    public MavenPublishPlugin(Instantiator instantiator, DependencyMetaDataProvider dependencyMetaDataProvider, FileResolver fileResolver, ProjectDependencyPublicationResolver projectDependencyResolver) {
        this.instantiator = instantiator;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.fileResolver = fileResolver;
        this.projectDependencyResolver = projectDependencyResolver;
    }

    public void apply(Project project) {
        project.getPlugins().apply(PublishingPlugin.class);
        TaskContainer tasks = project.getTasks();
        Task publishLocalLifecycleTask = tasks.create(PUBLISH_LOCAL_LIFECYCLE_TASK_NAME);
        publishLocalLifecycleTask.setDescription("Publishes all Maven publications produced by this project to the local Maven cache.");
        publishLocalLifecycleTask.setGroup("publishing");
        project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

            public void execute(PublishingExtension extension) {
                extension.getPublications().registerFactory(MavenPublication.class, (NamedDomainObjectFactory)new MavenPublicationFactory(MavenPublishPlugin.this.dependencyMetaDataProvider, MavenPublishPlugin.this.instantiator, MavenPublishPlugin.this.fileResolver));
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MavenPublicationFactory
    implements NamedDomainObjectFactory<MavenPublication> {
        private final Instantiator instantiator;
        private final DependencyMetaDataProvider dependencyMetaDataProvider;
        private final FileResolver fileResolver;

        private MavenPublicationFactory(DependencyMetaDataProvider dependencyMetaDataProvider, Instantiator instantiator, FileResolver fileResolver) {
            this.dependencyMetaDataProvider = dependencyMetaDataProvider;
            this.instantiator = instantiator;
            this.fileResolver = fileResolver;
        }

        public MavenPublication create(String name) {
            ModuleInternal module = this.dependencyMetaDataProvider.getModule();
            DefaultMavenProjectIdentity projectIdentity = new DefaultMavenProjectIdentity(module.getGroup(), module.getName(), module.getVersion());
            NotationParser<Object, MavenArtifact> artifactNotationParser = new MavenArtifactNotationParserFactory(this.instantiator, this.fileResolver).create();
            return (MavenPublication)this.instantiator.newInstance(DefaultMavenPublication.class, new Object[]{name, projectIdentity, artifactNotationParser, this.instantiator, MavenPublishPlugin.this.projectDependencyResolver});
        }
    }

    @RuleSource
    static class Rules {
        Rules() {
        }

        @Mutate
        public void realizePublishingTasks(TaskContainer tasks, PublishingExtension extension) {
            Task publishLifecycleTask = tasks.getByName("publish");
            Task publishLocalLifecycleTask = tasks.getByName(MavenPublishPlugin.PUBLISH_LOCAL_LIFECYCLE_TASK_NAME);
            PublicationContainer publications = extension.getPublications();
            for (MavenPublicationInternal publication : publications.withType(MavenPublicationInternal.class)) {
                String publicationName = publication.getName();
                this.createGeneratePomTask(tasks, publication, publicationName);
                this.createLocalInstallTask(tasks, publishLocalLifecycleTask, publication, publicationName);
                this.createPublishTasksForEachMavenRepo(tasks, extension, publishLifecycleTask, publication, publicationName);
            }
        }

        private void createPublishTasksForEachMavenRepo(TaskContainer tasks, PublishingExtension extension, Task publishLifecycleTask, MavenPublicationInternal publication, String publicationName) {
            for (MavenArtifactRepository repository : extension.getRepositories().withType(MavenArtifactRepository.class)) {
                String repositoryName = repository.getName();
                String publishTaskName = String.format("publish%sPublicationTo%sRepository", StringUtils.capitalize((String)publicationName), StringUtils.capitalize((String)repositoryName));
                PublishToMavenRepository publishTask = (PublishToMavenRepository)tasks.create(publishTaskName, PublishToMavenRepository.class);
                publishTask.setPublication(publication);
                publishTask.setRepository(repository);
                publishTask.setGroup("publishing");
                publishTask.setDescription(String.format("Publishes Maven publication '%s' to Maven repository '%s'.", publicationName, repositoryName));
                publishLifecycleTask.dependsOn(new Object[]{publishTask});
            }
        }

        private void createLocalInstallTask(TaskContainer tasks, Task publishLocalLifecycleTask, MavenPublicationInternal publication, String publicationName) {
            String installTaskName = String.format("publish%sPublicationToMavenLocal", StringUtils.capitalize((String)publicationName));
            PublishToMavenLocal publishLocalTask = (PublishToMavenLocal)tasks.create(installTaskName, PublishToMavenLocal.class);
            publishLocalTask.setPublication(publication);
            publishLocalTask.setGroup("publishing");
            publishLocalTask.setDescription(String.format("Publishes Maven publication '%s' to the local Maven repository.", publicationName));
            publishLocalLifecycleTask.dependsOn(new Object[]{installTaskName});
        }

        private void createGeneratePomTask(TaskContainer tasks, final MavenPublicationInternal publication, String publicationName) {
            String descriptorTaskName = String.format("generatePomFileFor%sPublication", StringUtils.capitalize((String)publicationName));
            final GenerateMavenPom generatePomTask = (GenerateMavenPom)tasks.create(descriptorTaskName, GenerateMavenPom.class);
            generatePomTask.setDescription(String.format("Generates the Maven POM file for publication '%s'.", publication.getName()));
            generatePomTask.setGroup("publishing");
            generatePomTask.setPom(publication.getPom());
            ConventionMapping descriptorTaskConventionMapping = new DslObject((Object)generatePomTask).getConventionMapping();
            descriptorTaskConventionMapping.map("destination", (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return new File(generatePomTask.getProject().getBuildDir(), "publications/" + publication.getName() + "/pom-default.xml");
                }
            });
            publication.setPomFile(generatePomTask.getOutputs().getFiles());
        }
    }
}

