/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import org.apache.maven.artifact.ant.Authentication;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.internal.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MavenRemoteRepositoryFactory
implements Factory<RemoteRepository> {
    private final MavenArtifactRepository artifactRepository;

    public MavenRemoteRepositoryFactory(MavenArtifactRepository artifactRepository) {
        this.artifactRepository = artifactRepository;
    }

    public RemoteRepository create() {
        RemoteRepository remoteRepository = new RemoteRepository();
        remoteRepository.setUrl(this.artifactRepository.getUrl().toString());
        PasswordCredentials credentials = this.artifactRepository.getCredentials();
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        if (username != null || password != null) {
            Authentication authentication = new Authentication();
            authentication.setUserName(username);
            authentication.setPassword(password);
            remoteRepository.addAuthentication(authentication);
        }
        return remoteRepository;
    }
}

