/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.publisher;

import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.ant.AttachedArtifact;
import org.apache.maven.artifact.ant.InstallDeployTaskSupport;
import org.apache.maven.artifact.ant.Pom;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.publication.maven.internal.ant.EmptyMavenSettingsSupplier;
import org.gradle.api.publish.maven.InvalidMavenPublicationException;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.util.AntUtil;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAntTaskBackedMavenPublisher<T extends InstallDeployTaskSupport>
implements MavenPublisher {
    private final Factory<LoggingManagerInternal> loggingManagerFactory;
    private static Logger logger = LoggerFactory.getLogger(AbstractAntTaskBackedMavenPublisher.class);
    protected final Factory<File> temporaryDirFactory;

    public AbstractAntTaskBackedMavenPublisher(Factory<LoggingManagerInternal> loggingManagerFactory, Factory<File> temporaryDirFactory) {
        this.loggingManagerFactory = loggingManagerFactory;
        this.temporaryDirFactory = temporaryDirFactory;
    }

    @Override
    public void publish(MavenNormalizedPublication publication, MavenArtifactRepository artifactRepository) {
        logger.info("Publishing to repository {}", (Object)artifactRepository);
        T deployTask = this.createDeployTask();
        deployTask.setProject(AntUtil.createProject());
        EmptyMavenSettingsSupplier mavenSettingsSupplier = new EmptyMavenSettingsSupplier();
        mavenSettingsSupplier.supply((InstallDeployTaskSupport)deployTask);
        this.postConfigure(deployTask, artifactRepository);
        this.addPomAndArtifacts((InstallDeployTaskSupport)deployTask, publication);
        this.execute((InstallDeployTaskSupport)deployTask);
        mavenSettingsSupplier.done();
    }

    protected abstract void postConfigure(T var1, MavenArtifactRepository var2);

    protected abstract T createDeployTask();

    private void addPomAndArtifacts(InstallDeployTaskSupport installOrDeployTask, MavenNormalizedPublication publication) {
        Pom pom = new Pom();
        pom.setProject(installOrDeployTask.getProject());
        pom.setFile(publication.getPomFile());
        installOrDeployTask.addPom(pom);
        MavenArtifact mainArtifact = this.determineMainArtifact(publication.getName(), publication.getArtifacts());
        installOrDeployTask.setFile(mainArtifact == null ? publication.getPomFile() : mainArtifact.getFile());
        for (MavenArtifact mavenArtifact : publication.getArtifacts()) {
            if (mavenArtifact == mainArtifact) continue;
            AttachedArtifact attachedArtifact = installOrDeployTask.createAttach();
            attachedArtifact.setClassifier((String)GUtil.elvis((Object)mavenArtifact.getClassifier(), (Object)""));
            attachedArtifact.setType((String)GUtil.elvis((Object)mavenArtifact.getExtension(), (Object)""));
            attachedArtifact.setFile(mavenArtifact.getFile());
        }
    }

    private MavenArtifact determineMainArtifact(String publicationName, Set<MavenArtifact> mavenArtifacts) {
        Set candidateMainArtifacts = CollectionUtils.filter(mavenArtifacts, (Spec)new Spec<MavenArtifact>(){

            public boolean isSatisfiedBy(MavenArtifact element) {
                return element.getClassifier() == null || element.getClassifier().length() == 0;
            }
        });
        if (candidateMainArtifacts.isEmpty()) {
            return null;
        }
        if (candidateMainArtifacts.size() > 1) {
            throw new InvalidMavenPublicationException(publicationName, "Cannot determine main artifact - multiple artifacts found with empty classifier.");
        }
        return (MavenArtifact)candidateMainArtifacts.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(InstallDeployTaskSupport deployTask) {
        LoggingManagerInternal loggingManager = (LoggingManagerInternal)this.loggingManagerFactory.create();
        loggingManager.captureStandardOutput(LogLevel.INFO).start();
        try {
            deployTask.execute();
        }
        finally {
            loggingManager.stop();
        }
    }
}

