/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.ant;

import groovy.lang.Closure;
import java.io.File;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.maven.artifact.ant.AttachedArtifact;
import org.apache.maven.artifact.ant.InstallDeployTaskSupport;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.settings.Settings;
import org.apache.tools.ant.Project;
import org.gradle.api.Action;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.maven.MavenDeployment;
import org.gradle.api.artifacts.maven.MavenPom;
import org.gradle.api.artifacts.maven.MavenResolver;
import org.gradle.api.artifacts.maven.PomFilterContainer;
import org.gradle.api.artifacts.maven.PublishFilter;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionArtifactPublishMetaData;
import org.gradle.api.internal.artifacts.metadata.ModuleVersionPublishMetaData;
import org.gradle.api.internal.artifacts.repositories.AbstractArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.publication.maven.internal.ArtifactPomContainer;
import org.gradle.api.publication.maven.internal.PomFilter;
import org.gradle.api.publication.maven.internal.ant.CustomInstallDeployTaskSupport;
import org.gradle.api.publication.maven.internal.ant.EmptyMavenSettingsSupplier;
import org.gradle.api.publication.maven.internal.ant.MavenSettingsSupplier;
import org.gradle.listener.ActionBroadcast;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.util.AntUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenResolver
extends AbstractArtifactRepository
implements MavenResolver,
ModuleVersionPublisher,
ResolutionAwareRepository,
PublicationAwareRepository {
    private ArtifactPomContainer artifactPomContainer;
    private PomFilterContainer pomFilterContainer;
    private Settings settings;
    private LoggingManagerInternal loggingManager;
    private final ActionBroadcast<MavenDeployment> beforeDeploymentActions = new ActionBroadcast();
    protected MavenSettingsSupplier mavenSettingsSupplier = new EmptyMavenSettingsSupplier();

    public AbstractMavenResolver(PomFilterContainer pomFilterContainer, ArtifactPomContainer artifactPomContainer, LoggingManagerInternal loggingManager) {
        this.pomFilterContainer = pomFilterContainer;
        this.artifactPomContainer = artifactPomContainer;
        this.loggingManager = loggingManager;
    }

    public ConfiguredModuleComponentRepository createResolver() {
        throw new UnsupportedOperationException("A Maven deployer cannot be used to resolve dependencies. It can only be used to publish artifacts.");
    }

    public ModuleVersionPublisher createPublisher() {
        return this;
    }

    protected abstract InstallDeployTaskSupport createPreConfiguredTask(Project var1);

    public void publish(ModuleVersionPublishMetaData moduleVersion) {
        for (ModuleVersionArtifactPublishMetaData artifact : moduleVersion.getArtifacts()) {
            this.collectArtifact(artifact.toIvyArtifact(), artifact.getFile());
        }
        this.publish();
    }

    private void collectArtifact(Artifact artifact, File src) {
        if (this.isIgnorable(artifact)) {
            return;
        }
        this.getArtifactPomContainer().addArtifact(artifact, src);
    }

    private boolean isIgnorable(Artifact artifact) {
        return artifact.getType().equals("ivy");
    }

    private void publish() {
        InstallDeployTaskSupport installDeployTaskSupport = this.createPreConfiguredTask(AntUtil.createProject());
        Set<MavenDeployment> mavenDeployments = this.getArtifactPomContainer().createDeployableFilesInfos();
        this.mavenSettingsSupplier.supply(installDeployTaskSupport);
        for (MavenDeployment mavenDeployment : mavenDeployments) {
            ((CustomInstallDeployTaskSupport)installDeployTaskSupport).clearAttachedArtifactsList();
            this.beforeDeploymentActions.execute((Object)mavenDeployment);
            this.addPomAndArtifact(installDeployTaskSupport, mavenDeployment);
            this.execute(installDeployTaskSupport);
        }
        this.mavenSettingsSupplier.done();
        this.settings = ((CustomInstallDeployTaskSupport)installDeployTaskSupport).getSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(InstallDeployTaskSupport deployTask) {
        this.loggingManager.captureStandardOutput(LogLevel.INFO).start();
        try {
            deployTask.execute();
        }
        finally {
            this.loggingManager.stop();
        }
    }

    private void addPomAndArtifact(InstallDeployTaskSupport installOrDeployTask, MavenDeployment mavenDeployment) {
        Pom pom = new Pom();
        pom.setProject(installOrDeployTask.getProject());
        pom.setFile(mavenDeployment.getPomArtifact().getFile());
        installOrDeployTask.addPom(pom);
        if (mavenDeployment.getMainArtifact() != null) {
            installOrDeployTask.setFile(mavenDeployment.getMainArtifact().getFile());
        }
        for (PublishArtifact classifierArtifact : mavenDeployment.getAttachedArtifacts()) {
            AttachedArtifact attachedArtifact = installOrDeployTask.createAttach();
            attachedArtifact.setClassifier(classifierArtifact.getClassifier());
            attachedArtifact.setFile(classifierArtifact.getFile());
            attachedArtifact.setType(classifierArtifact.getType());
        }
    }

    public ArtifactPomContainer getArtifactPomContainer() {
        return this.artifactPomContainer;
    }

    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public PublishFilter getFilter() {
        return this.pomFilterContainer.getFilter();
    }

    @Override
    public void setFilter(PublishFilter defaultFilter) {
        this.pomFilterContainer.setFilter(defaultFilter);
    }

    @Override
    public MavenPom getPom() {
        return this.pomFilterContainer.getPom();
    }

    @Override
    public void setPom(MavenPom defaultPom) {
        this.pomFilterContainer.setPom(defaultPom);
    }

    @Override
    public MavenPom addFilter(String name, PublishFilter publishFilter) {
        return this.pomFilterContainer.addFilter(name, publishFilter);
    }

    @Override
    public MavenPom addFilter(String name, Closure filter) {
        return this.pomFilterContainer.addFilter(name, filter);
    }

    @Override
    public void filter(Closure filter) {
        this.pomFilterContainer.filter(filter);
    }

    @Override
    public PublishFilter filter(String name) {
        return this.pomFilterContainer.filter(name);
    }

    @Override
    public MavenPom pom(String name) {
        return this.pomFilterContainer.pom(name);
    }

    @Override
    public MavenPom pom(Closure configureClosure) {
        return this.pomFilterContainer.pom(configureClosure);
    }

    @Override
    public MavenPom pom(String name, Closure configureClosure) {
        return this.pomFilterContainer.pom(name, configureClosure);
    }

    @Override
    public Iterable<PomFilter> getActivePomFilters() {
        return this.pomFilterContainer.getActivePomFilters();
    }

    public PomFilterContainer getPomFilterContainer() {
        return this.pomFilterContainer;
    }

    @Override
    public void beforeDeployment(Action<? super MavenDeployment> action) {
        this.beforeDeploymentActions.add(action);
    }

    @Override
    public void beforeDeployment(Closure action) {
        this.beforeDeploymentActions.add((Action)new ClosureBackedAction(action));
    }
}

