/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal;

import antlr.preprocessor.Hierarchy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.gradle.api.plugins.antlr.internal.GrammarFileMetadata;
import org.gradle.api.plugins.antlr.internal.GrammarMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XRef {
    private final Hierarchy antlrHierarchy;
    private LinkedHashMap<String, GrammarFileMetadata> filesByPath = new LinkedHashMap();
    private HashMap<String, GrammarFileMetadata> filesByExportVocab = new HashMap();
    private HashMap<String, GrammarFileMetadata> filesByClassName = new HashMap();

    public XRef(Hierarchy antlrHierarchy) {
        this.antlrHierarchy = antlrHierarchy;
    }

    public Object getAntlrHierarchy() {
        return this.antlrHierarchy;
    }

    void addGrammarFile(GrammarFileMetadata grammarFileMetadata) {
        this.filesByPath.put(grammarFileMetadata.getFilePath().getPath(), grammarFileMetadata);
        for (GrammarMetadata grammarMetadata : grammarFileMetadata.getGrammars()) {
            GrammarFileMetadata old;
            this.filesByClassName.put(grammarMetadata.getClassName(), grammarFileMetadata);
            if (grammarMetadata.getExportVocab() == null || (old = this.filesByExportVocab.put(grammarMetadata.getExportVocab(), grammarFileMetadata)) == null || old == grammarFileMetadata) continue;
            System.out.println("[WARNING] : multiple grammars defined the same exportVocab : " + grammarMetadata.getExportVocab());
        }
    }

    public Iterator<GrammarFileMetadata> iterateGrammarFiles() {
        return this.filesByPath.values().iterator();
    }

    public GrammarFileMetadata getGrammarFileByPath(String path) {
        return this.filesByPath.get(path);
    }

    public GrammarFileMetadata getGrammarFileByClassName(String className) {
        return this.filesByClassName.get(className);
    }

    public GrammarFileMetadata getGrammarFileByExportVocab(String vocabName) {
        return this.filesByExportVocab.get(vocabName);
    }
}

