/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.sonatype.aether.impl.internal;

import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Component;
import org.gradle.mvn3.org.codehaus.plexus.component.annotations.Requirement;
import org.gradle.mvn3.org.sonatype.aether.impl.internal.EnhancedLocalRepositoryManager;
import org.gradle.mvn3.org.sonatype.aether.repository.LocalRepository;
import org.gradle.mvn3.org.sonatype.aether.repository.LocalRepositoryManager;
import org.gradle.mvn3.org.sonatype.aether.repository.NoLocalRepositoryManagerException;
import org.gradle.mvn3.org.sonatype.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.gradle.mvn3.org.sonatype.aether.spi.locator.Service;
import org.gradle.mvn3.org.sonatype.aether.spi.locator.ServiceLocator;
import org.gradle.mvn3.org.sonatype.aether.spi.log.Logger;
import org.gradle.mvn3.org.sonatype.aether.spi.log.NullLogger;

@Component(role=LocalRepositoryManagerFactory.class, hint="enhanced")
public class EnhancedLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;

    public LocalRepositoryManager newInstance(LocalRepository repository) throws NoLocalRepositoryManagerException {
        if ("".equals(repository.getContentType()) || "default".equals(repository.getContentType())) {
            return new EnhancedLocalRepositoryManager(repository.getBasedir()).setLogger(this.logger);
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    public void initService(ServiceLocator locator) {
        this.setLogger((Logger)locator.getService(Logger.class));
    }

    public EnhancedLocalRepositoryManagerFactory setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public int getPriority() {
        return 10;
    }
}

