/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.runtime.jvm.plugins;

import java.io.File;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.Model;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.runtime.base.BinaryContainer;
import org.gradle.runtime.base.ComponentSpecContainer;
import org.gradle.runtime.base.ComponentSpecIdentifier;
import org.gradle.runtime.base.internal.BinaryNamingScheme;
import org.gradle.runtime.base.internal.BinaryNamingSchemeBuilder;
import org.gradle.runtime.base.internal.DefaultBinaryNamingSchemeBuilder;
import org.gradle.runtime.base.internal.DefaultComponentSpecIdentifier;
import org.gradle.runtime.jvm.JvmLibrarySpec;
import org.gradle.runtime.jvm.internal.DefaultJarBinarySpec;
import org.gradle.runtime.jvm.internal.DefaultJvmLibrarySpec;
import org.gradle.runtime.jvm.internal.JarBinarySpecInternal;
import org.gradle.runtime.jvm.internal.plugins.DefaultJvmComponentExtension;
import org.gradle.runtime.jvm.toolchain.JavaToolChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JvmComponentPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        project.getPlugins().apply(ComponentModelBasePlugin.class);
        ComponentSpecContainer componentSpecs = (ComponentSpecContainer)project.getExtensions().getByType(ComponentSpecContainer.class);
        final ProjectSourceSet sources = (ProjectSourceSet)project.getExtensions().getByType(ProjectSourceSet.class);
        componentSpecs.registerFactory(JvmLibrarySpec.class, (NamedDomainObjectFactory)new NamedDomainObjectFactory<JvmLibrarySpec>(){

            public JvmLibrarySpec create(String name) {
                DefaultComponentSpecIdentifier id = new DefaultComponentSpecIdentifier(project.getPath(), name);
                return new DefaultJvmLibrarySpec((ComponentSpecIdentifier)id, (FunctionalSourceSet)sources.maybeCreate(name));
            }
        });
        NamedDomainObjectContainer jvmLibraries = componentSpecs.containerWithType(JvmLibrarySpec.class);
        project.getExtensions().create("jvm", DefaultJvmComponentExtension.class, new Object[]{jvmLibraries});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @RuleSource
    public static class Rules {
        @Model(value="jvm.libraries")
        NamedDomainObjectCollection<JvmLibrarySpec> jvmLibraries(ComponentSpecContainer components) {
            return components.withType(JvmLibrarySpec.class);
        }

        @Model
        BinaryNamingSchemeBuilder binaryNamingSchemeBuilder() {
            return new DefaultBinaryNamingSchemeBuilder();
        }

        @Mutate
        public void createBinaries(BinaryContainer binaries, BinaryNamingSchemeBuilder namingSchemeBuilder, NamedDomainObjectCollection<JvmLibrarySpec> libraries, @Path(value="buildDir") File buildDir, ServiceRegistry serviceRegistry) {
            JavaToolChain toolChain = (JavaToolChain)serviceRegistry.get(JavaToolChain.class);
            for (JvmLibrarySpec jvmLibrary : libraries) {
                BinaryNamingScheme namingScheme = namingSchemeBuilder.withComponentName(jvmLibrary.getName()).withTypeString("jar").build();
                DefaultJarBinarySpec jarBinary = new DefaultJarBinarySpec(jvmLibrary, namingScheme, toolChain);
                jarBinary.source(jvmLibrary.getSource());
                this.configureBinaryOutputLocations(jarBinary, buildDir);
                jvmLibrary.getBinaries().add((Object)jarBinary);
                binaries.add((Object)jarBinary);
            }
        }

        private void configureBinaryOutputLocations(JarBinarySpecInternal jarBinary, File buildDir) {
            File binariesDir = new File(buildDir, "jars");
            File classesDir = new File(buildDir, "classes");
            String outputBaseName = jarBinary.getNamingScheme().getOutputDirectoryBase();
            File outputDir = new File(classesDir, outputBaseName);
            jarBinary.setClassesDir(outputDir);
            jarBinary.setResourcesDir(outputDir);
            jarBinary.setJarFile(new File(binariesDir, String.format("%s/%s.jar", outputBaseName, jarBinary.getLibrary().getName())));
        }

        @Mutate
        public void createTasks(TaskContainer tasks, BinaryContainer binaries) {
            for (JarBinarySpecInternal projectJarBinary : binaries.withType(JarBinarySpecInternal.class)) {
                Task jarTask = this.createJarTask(tasks, projectJarBinary);
                projectJarBinary.builtBy(new Object[]{jarTask});
                projectJarBinary.getTasks().add(jarTask);
            }
        }

        private Task createJarTask(TaskContainer tasks, JarBinarySpecInternal binary) {
            Jar jar = (Jar)tasks.create(binary.getNamingScheme().getTaskName("create"), Jar.class);
            jar.setDescription(String.format("Creates the binary file for %s.", binary.getNamingScheme().getDescription()));
            jar.from(new Object[]{binary.getClassesDir()});
            jar.from(new Object[]{binary.getResourcesDir()});
            jar.setDestinationDir(binary.getJarFile().getParentFile());
            jar.setArchiveName(binary.getJarFile().getName());
            return jar;
        }
    }
}

