/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.runtime.jvm.internal;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageSourceSetContainer;
import org.gradle.runtime.base.ComponentSpecIdentifier;
import org.gradle.runtime.base.TransformationFileType;
import org.gradle.runtime.base.internal.ComponentSpecInternal;
import org.gradle.runtime.jvm.JvmByteCode;
import org.gradle.runtime.jvm.JvmLibraryBinarySpec;
import org.gradle.runtime.jvm.JvmLibrarySpec;
import org.gradle.runtime.jvm.JvmResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJvmLibrarySpec
implements JvmLibrarySpec,
ComponentSpecInternal {
    private final LanguageSourceSetContainer sourceSets = new LanguageSourceSetContainer();
    private final FunctionalSourceSet mainSourceSet;
    private final ComponentSpecIdentifier identifier;
    private final DomainObjectSet<JvmLibraryBinarySpec> binaries = new DefaultDomainObjectSet(JvmLibraryBinarySpec.class);
    private final Set<Class<? extends TransformationFileType>> languageOutputs = new HashSet<Class<? extends TransformationFileType>>();

    public DefaultJvmLibrarySpec(ComponentSpecIdentifier identifier, FunctionalSourceSet mainSourceSet) {
        this.identifier = identifier;
        this.mainSourceSet = mainSourceSet;
        this.sourceSets.addMainSources(mainSourceSet);
        this.languageOutputs.add(JvmResources.class);
        this.languageOutputs.add(JvmByteCode.class);
    }

    public String getName() {
        return this.identifier.getName();
    }

    public String getProjectPath() {
        return this.identifier.getProjectPath();
    }

    public String getDisplayName() {
        return String.format("JVM library '%s'", this.getName());
    }

    public String toString() {
        return this.getDisplayName();
    }

    public DomainObjectSet<LanguageSourceSet> getSource() {
        return this.sourceSets;
    }

    public void source(Object source) {
        this.sourceSets.source(source);
    }

    @Override
    public DomainObjectSet<JvmLibraryBinarySpec> getBinaries() {
        return this.binaries;
    }

    public FunctionalSourceSet getMainSource() {
        return this.mainSourceSet;
    }

    public Set<Class<? extends TransformationFileType>> getInputTypes() {
        return this.languageOutputs;
    }
}

