/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.jvm.plugins;

import java.util.Collections;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageRegistration;
import org.gradle.language.base.internal.LanguageRegistry;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.jvm.ResourceSet;
import org.gradle.language.jvm.internal.DefaultResourceSet;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.runtime.base.BinarySpec;
import org.gradle.runtime.base.TransformationFileType;
import org.gradle.runtime.jvm.JvmLibraryBinarySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JvmResourcesPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(ComponentModelBasePlugin.class);
        ((LanguageRegistry)project.getExtensions().getByType(LanguageRegistry.class)).add((Object)new JvmResources());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JvmResources
    implements LanguageRegistration<ResourceSet> {
        private JvmResources() {
        }

        public String getName() {
            return "resources";
        }

        public Class<ResourceSet> getSourceSetType() {
            return ResourceSet.class;
        }

        public Class<? extends ResourceSet> getSourceSetImplementation() {
            return DefaultResourceSet.class;
        }

        public Map<String, Class<?>> getBinaryTools() {
            return Collections.emptyMap();
        }

        public Class<? extends TransformationFileType> getOutputType() {
            return org.gradle.runtime.jvm.JvmResources.class;
        }

        public SourceTransformTaskConfig getTransformTask() {
            return new SourceTransformTaskConfig(){

                public String getTaskPrefix() {
                    return "process";
                }

                public Class<? extends DefaultTask> getTaskType() {
                    return ProcessResources.class;
                }

                public void configureTask(Task task, BinarySpec binary, LanguageSourceSet sourceSet) {
                    ProcessResources resourcesTask = (ProcessResources)task;
                    ResourceSet resourceSet = (ResourceSet)sourceSet;
                    JvmLibraryBinarySpec jvmBinary = (JvmLibraryBinarySpec)binary;
                    resourcesTask.from(new Object[]{resourceSet.getSource()});
                    resourcesTask.setDestinationDir(jvmBinary.getResourcesDir());
                    jvmBinary.getTasks().getJar().dependsOn(new Object[]{resourcesTask});
                }
            };
        }

        public boolean applyToBinary(BinarySpec binary) {
            return binary instanceof JvmLibraryBinarySpec;
        }
    }
}

