/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.java.plugins;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.LanguageRegistration;
import org.gradle.language.base.internal.LanguageRegistry;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.java.JavaSourceSet;
import org.gradle.language.java.internal.DefaultJavaSourceSet;
import org.gradle.language.jvm.plugins.JvmResourcesPlugin;
import org.gradle.runtime.base.BinarySpec;
import org.gradle.runtime.base.TransformationFileType;
import org.gradle.runtime.jvm.JvmByteCode;
import org.gradle.runtime.jvm.JvmLibraryBinarySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLanguagePlugin
implements Plugin<ProjectInternal> {
    public void apply(ProjectInternal project) {
        project.getPlugins().apply(ComponentModelBasePlugin.class);
        project.getPlugins().apply(JvmResourcesPlugin.class);
        ((LanguageRegistry)project.getExtensions().getByType(LanguageRegistry.class)).add((Object)new Java());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Java
    implements LanguageRegistration<JavaSourceSet> {
        private Java() {
        }

        public String getName() {
            return "java";
        }

        public Class<JavaSourceSet> getSourceSetType() {
            return JavaSourceSet.class;
        }

        public Class<? extends JavaSourceSet> getSourceSetImplementation() {
            return DefaultJavaSourceSet.class;
        }

        public Map<String, Class<?>> getBinaryTools() {
            return Collections.emptyMap();
        }

        public Class<? extends TransformationFileType> getOutputType() {
            return JvmByteCode.class;
        }

        public SourceTransformTaskConfig getTransformTask() {
            return new SourceTransformTaskConfig(){

                public String getTaskPrefix() {
                    return "compile";
                }

                public Class<? extends DefaultTask> getTaskType() {
                    return JavaCompile.class;
                }

                public void configureTask(Task task, BinarySpec binarySpec, LanguageSourceSet sourceSet) {
                    JavaCompile compile = (JavaCompile)task;
                    JavaSourceSet javaSourceSet = (JavaSourceSet)sourceSet;
                    JvmLibraryBinarySpec binary = (JvmLibraryBinarySpec)binarySpec;
                    compile.setDescription(String.format("Compiles %s.", javaSourceSet));
                    compile.setDestinationDir(binary.getClassesDir());
                    compile.setToolChain(binary.getToolChain());
                    compile.setSource(javaSourceSet.getSource());
                    compile.setClasspath(javaSourceSet.getCompileClasspath().getFiles());
                    compile.setSourceCompatibility(JavaVersion.current().toString());
                    compile.setTargetCompatibility(JavaVersion.current().toString());
                    compile.setDependencyCacheDir(new File(compile.getProject().getBuildDir(), "jvm-dep-cache"));
                    compile.dependsOn(new Object[]{javaSourceSet});
                    binary.getTasks().getJar().dependsOn(new Object[]{compile});
                }
            };
        }

        public boolean applyToBinary(BinarySpec binary) {
            return binary instanceof JvmLibraryBinarySpec;
        }
    }
}

