/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.java.internal;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.internal.AbstractLanguageSourceSet;
import org.gradle.language.java.JavaSourceSet;
import org.gradle.runtime.jvm.Classpath;

public class DefaultJavaSourceSet
extends AbstractLanguageSourceSet
implements JavaSourceSet {
    private final Classpath compileClasspath;

    @Inject
    public DefaultJavaSourceSet(String name, FunctionalSourceSet parent, FileResolver fileResolver) {
        super(name, parent, "Java source", (SourceDirectorySet)new DefaultSourceDirectorySet("source", fileResolver));
        this.compileClasspath = new EmptyClasspath();
    }

    public DefaultJavaSourceSet(String name, SourceDirectorySet source, Classpath compileClasspath, FunctionalSourceSet parent) {
        super(name, parent, "Java source", source);
        this.compileClasspath = compileClasspath;
    }

    public Classpath getCompileClasspath() {
        return this.compileClasspath;
    }

    public TaskDependency getBuildDependencies() {
        return new TaskDependency(){

            public Set<? extends Task> getDependencies(Task task) {
                HashSet dependencies = new HashSet();
                dependencies.addAll(DefaultJavaSourceSet.this.compileClasspath.getBuildDependencies().getDependencies(task));
                dependencies.addAll(DefaultJavaSourceSet.this.getSource().getBuildDependencies().getDependencies(task));
                return dependencies;
            }
        };
    }

    private static class EmptyClasspath
    implements Classpath {
        private EmptyClasspath() {
        }

        public FileCollection getFiles() {
            return new SimpleFileCollection(new File[0]);
        }

        public TaskDependency getBuildDependencies() {
            return new DefaultTaskDependency();
        }
    }
}

