/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.external.javadoc.internal;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.TreeMap;
import org.gradle.api.Action;
import org.gradle.external.javadoc.JavadocOptionFileOption;
import org.gradle.external.javadoc.internal.JavadocOptionFile;
import org.gradle.external.javadoc.internal.JavadocOptionFileWriterContext;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.IoActions;

public class JavadocOptionFileWriter {
    private final JavadocOptionFile optionFile;

    public JavadocOptionFileWriter(JavadocOptionFile optionFile) {
        if (optionFile == null) {
            throw new IllegalArgumentException("optionFile == null!");
        }
        this.optionFile = optionFile;
    }

    void write(File outputFile) throws IOException {
        IoActions.writeTextFile((File)outputFile, (Action)new ErroringAction<BufferedWriter>(){

            protected void doExecute(BufferedWriter writer) throws Exception {
                TreeMap<String, JavadocOptionFileOption> options = new TreeMap<String, JavadocOptionFileOption>(JavadocOptionFileWriter.this.optionFile.getOptions());
                JavadocOptionFileWriterContext writerContext = new JavadocOptionFileWriterContext(writer);
                JavadocOptionFileOption localeOption = (JavadocOptionFileOption)options.remove("locale");
                if (localeOption != null) {
                    localeOption.write(writerContext);
                }
                for (String option : options.keySet()) {
                    ((JavadocOptionFileOption)options.get(option)).write(writerContext);
                }
                JavadocOptionFileWriter.this.optionFile.getSourceNames().write(writerContext);
            }
        });
    }
}

