/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.AntBuilder;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.changes.IncrementalTaskInputsInternal;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.CleaningJavaCompiler;
import org.gradle.api.internal.tasks.compile.DefaultJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.IncrementalCompilerFactory;
import org.gradle.api.internal.tasks.compile.incremental.cache.DefaultCompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.cache.GeneralCompileCaches;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.cache.CacheRepository;
import org.gradle.internal.Factory;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.runtime.jvm.internal.toolchain.JavaToolChainInternal;
import org.gradle.runtime.jvm.toolchain.JavaToolChain;
import org.gradle.util.SingleMessageLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompile
extends AbstractCompile {
    private File dependencyCacheDir;
    private final CompileOptions compileOptions = new CompileOptions();
    private JavaToolChain toolChain;

    @Incubating
    public JavaToolChain getToolChain() {
        if (this.toolChain == null) {
            this.toolChain = (JavaToolChain)this.getServices().get(JavaToolChain.class);
        }
        return this.toolChain;
    }

    @Incubating
    public void setToolChain(JavaToolChain toolChain) {
        this.toolChain = toolChain;
    }

    @TaskAction
    protected void compile(IncrementalTaskInputs inputs) {
        if (!this.compileOptions.isIncremental()) {
            this.compile();
            return;
        }
        SingleMessageLogger.incubatingFeatureUsed((String)"Incremental java compilation");
        DefaultJavaCompileSpec spec = this.createSpec();
        DefaultCompileCaches compileCaches = new DefaultCompileCaches(this.getCacheRepository(), this, this.getGeneralCompileCaches());
        IncrementalCompilerFactory factory = new IncrementalCompilerFactory((FileOperations)this.getProject(), this.getPath(), this.createCompiler(spec), this.source, compileCaches, (IncrementalTaskInputsInternal)inputs);
        Compiler<JavaCompileSpec> compiler = factory.createCompiler();
        this.performCompilation(spec, compiler);
    }

    @Inject
    protected GeneralCompileCaches getGeneralCompileCaches() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected CacheRepository getCacheRepository() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void compile() {
        DefaultJavaCompileSpec spec = this.createSpec();
        this.performCompilation(spec, this.createCompiler(spec));
    }

    @Inject
    protected Factory<AntBuilder> getAntBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    private CleaningJavaCompiler createCompiler(JavaCompileSpec spec) {
        Compiler javaCompiler = ((JavaToolChainInternal)this.getToolChain()).newCompiler(spec);
        return new CleaningJavaCompiler((Compiler<JavaCompileSpec>)javaCompiler, this.getAntBuilderFactory(), this.getOutputs());
    }

    private void performCompilation(JavaCompileSpec spec, Compiler<JavaCompileSpec> compiler) {
        WorkResult result = compiler.execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private DefaultJavaCompileSpec createSpec() {
        DefaultJavaCompileSpec spec = new DefaultJavaCompileSpec();
        spec.setSource((FileCollection)this.getSource());
        spec.setDestinationDir(this.getDestinationDir());
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setTempDir(this.getTemporaryDir());
        spec.setClasspath((Iterable<File>)this.getClasspath());
        spec.setDependencyCacheDir(this.getDependencyCacheDir());
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setCompileOptions(this.compileOptions);
        return spec;
    }

    @OutputDirectory
    public File getDependencyCacheDir() {
        return this.dependencyCacheDir;
    }

    public void setDependencyCacheDir(File dependencyCacheDir) {
        this.dependencyCacheDir = dependencyCacheDir;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }
}

