/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import java.io.File;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.CleaningGroovyCompiler;
import org.gradle.api.internal.tasks.compile.DefaultGroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.GroovyCompilerFactory;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonManager;
import org.gradle.api.internal.tasks.compile.daemon.InProcessCompilerDaemonFactory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompileOptions;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyCompile
extends AbstractCompile {
    private Compiler<GroovyJavaJointCompileSpec> compiler;
    private FileCollection groovyClasspath;
    private final CompileOptions compileOptions = new CompileOptions();
    private final GroovyCompileOptions groovyCompileOptions = new GroovyCompileOptions();

    @Override
    @TaskAction
    protected void compile() {
        this.checkGroovyClasspathIsNonEmpty();
        DefaultGroovyJavaJointCompileSpec spec = this.createSpec();
        WorkResult result = this.getCompiler(spec).execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private Compiler<GroovyJavaJointCompileSpec> getCompiler(GroovyJavaJointCompileSpec spec) {
        if (this.compiler == null) {
            ProjectInternal projectInternal = (ProjectInternal)this.getProject();
            CompilerDaemonManager compilerDaemonManager = (CompilerDaemonManager)this.getServices().get(CompilerDaemonManager.class);
            InProcessCompilerDaemonFactory inProcessCompilerDaemonFactory = (InProcessCompilerDaemonFactory)this.getServices().get(InProcessCompilerDaemonFactory.class);
            JavaCompilerFactory javaCompilerFactory = (JavaCompilerFactory)this.getServices().get(JavaCompilerFactory.class);
            GroovyCompilerFactory groovyCompilerFactory = new GroovyCompilerFactory(projectInternal, javaCompilerFactory, compilerDaemonManager, inProcessCompilerDaemonFactory);
            Compiler<GroovyJavaJointCompileSpec> delegatingCompiler = groovyCompilerFactory.newCompiler(spec);
            this.compiler = new CleaningGroovyCompiler(delegatingCompiler, this.getOutputs());
        }
        return this.compiler;
    }

    private DefaultGroovyJavaJointCompileSpec createSpec() {
        DefaultGroovyJavaJointCompileSpec spec = new DefaultGroovyJavaJointCompileSpec();
        spec.setSource((FileCollection)this.getSource());
        spec.setDestinationDir(this.getDestinationDir());
        spec.setWorkingDir(this.getProject().getProjectDir());
        spec.setTempDir(this.getTemporaryDir());
        spec.setClasspath((Iterable<File>)this.getClasspath());
        spec.setSourceCompatibility(this.getSourceCompatibility());
        spec.setTargetCompatibility(this.getTargetCompatibility());
        spec.setGroovyClasspath((Iterable<File>)this.getGroovyClasspath());
        spec.setCompileOptions(this.compileOptions);
        spec.setGroovyCompileOptions(this.groovyCompileOptions);
        if (spec.getGroovyCompileOptions().getStubDir() == null) {
            File dir = new File(this.getTemporaryDir(), "groovy-java-stubs");
            GFileUtils.mkdirs((File)dir);
            spec.getGroovyCompileOptions().setStubDir(dir);
        }
        return spec;
    }

    private void checkGroovyClasspathIsNonEmpty() {
        if (this.getGroovyClasspath().isEmpty()) {
            throw new InvalidUserDataException("'" + this.getName() + ".groovyClasspath' must not be empty. If a Groovy compile dependency is provided, " + "the 'groovy-base' plugin will attempt to configure 'groovyClasspath' automatically. Alternatively, you may configure 'groovyClasspath' explicitly.");
        }
    }

    @Nested
    public GroovyCompileOptions getGroovyOptions() {
        return this.groovyCompileOptions;
    }

    @Nested
    public CompileOptions getOptions() {
        return this.compileOptions;
    }

    @InputFiles
    public FileCollection getGroovyClasspath() {
        return this.groovyClasspath;
    }

    public void setGroovyClasspath(FileCollection groovyClasspath) {
        this.groovyClasspath = groovyClasspath;
    }

    public Compiler<GroovyJavaJointCompileSpec> getCompiler() {
        return this.getCompiler(this.createSpec());
    }

    public void setCompiler(Compiler<GroovyJavaJointCompileSpec> compiler) {
        this.compiler = compiler;
    }
}

