/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import org.gradle.api.Action;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.incremental.SourceToNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.model.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.DefaultRecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.JarChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.JavaChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;

public class RecompilationSpecProvider {
    private final SourceToNameConverter sourceToNameConverter;
    private final FileOperations fileOperations;

    public RecompilationSpecProvider(SourceToNameConverter sourceToNameConverter, FileOperations fileOperations) {
        this.sourceToNameConverter = sourceToNameConverter;
        this.fileOperations = fileOperations;
    }

    public RecompilationSpec provideRecompilationSpec(IncrementalTaskInputs inputs, PreviousCompilation previousCompilation, JarClasspathSnapshot jarClasspathSnapshot) {
        DefaultRecompilationSpec spec = new DefaultRecompilationSpec();
        JavaChangeProcessor javaChangeProcessor = new JavaChangeProcessor(previousCompilation, this.sourceToNameConverter);
        JarChangeProcessor jarChangeProcessor = new JarChangeProcessor(this.fileOperations, jarClasspathSnapshot, previousCompilation);
        InputChangeAction action = new InputChangeAction(spec, javaChangeProcessor, jarChangeProcessor);
        inputs.outOfDate((Action)action);
        if (action.spec.getFullRebuildCause() != null) {
            return action.spec;
        }
        inputs.removed((Action)action);
        return action.spec;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InputChangeAction
    implements Action<InputFileDetails> {
        private final DefaultRecompilationSpec spec;
        private final JavaChangeProcessor javaChangeProcessor;
        private final JarChangeProcessor jarChangeProcessor;

        public InputChangeAction(DefaultRecompilationSpec spec, JavaChangeProcessor javaChangeProcessor, JarChangeProcessor jarChangeProcessor) {
            this.spec = spec;
            this.javaChangeProcessor = javaChangeProcessor;
            this.jarChangeProcessor = jarChangeProcessor;
        }

        public void execute(InputFileDetails input) {
            if (this.spec.getFullRebuildCause() != null) {
                return;
            }
            if (input.getFile().getName().endsWith(".java")) {
                this.javaChangeProcessor.processChange(input, this.spec);
            }
            if (input.getFile().getName().endsWith(".jar")) {
                this.jarChangeProcessor.processChange(input, this.spec);
            }
        }
    }
}

