/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import org.gradle.api.internal.tasks.compile.incremental.SourceToNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.model.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.DefaultRecompilationSpec;
import org.gradle.api.tasks.incremental.InputFileDetails;

class JavaChangeProcessor {
    private final SourceToNameConverter sourceToNameConverter;
    private final PreviousCompilation previousCompilation;

    public JavaChangeProcessor(PreviousCompilation previousCompilation, SourceToNameConverter sourceToNameConverter) {
        this.previousCompilation = previousCompilation;
        this.sourceToNameConverter = sourceToNameConverter;
    }

    public void processChange(InputFileDetails input, DefaultRecompilationSpec spec) {
        String className = this.sourceToNameConverter.getClassName(input.getFile());
        spec.classesToCompile.add(className);
        DependentsSet actualDependents = this.previousCompilation.getDependents(className);
        if (actualDependents.isDependencyToAll()) {
            spec.setFullRebuildCause(actualDependents.getDescription(), input.getFile());
            return;
        }
        spec.classesToCompile.addAll(actualDependents.getDependentClasses());
    }
}

