/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.util.Map;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisDataSerializer;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;
import org.gradle.messaging.serialize.BaseSerializerFactory;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.MapSerializer;
import org.gradle.messaging.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarSnapshotDataSerializer
implements Serializer<JarSnapshotData> {
    private final MapSerializer<String, byte[]> mapSerializer = new MapSerializer(BaseSerializerFactory.STRING_SERIALIZER, BaseSerializerFactory.BYTE_ARRAY_SERIALIZER);
    private final Serializer<ClassSetAnalysisData> analysisSerializer = new ClassSetAnalysisDataSerializer();

    public JarSnapshotData read(Decoder decoder) throws Exception {
        byte[] hash = decoder.readBinary();
        Map hashes = this.mapSerializer.read(decoder);
        ClassSetAnalysisData data = (ClassSetAnalysisData)this.analysisSerializer.read(decoder);
        return new JarSnapshotData(hash, hashes, data);
    }

    public void write(Encoder encoder, JarSnapshotData value) throws Exception {
        encoder.writeBinary(value.hash);
        this.mapSerializer.write(encoder, value.hashes);
        this.analysisSerializer.write(encoder, (Object)value.data);
    }
}

