/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.DefaultDependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependencyToAll;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.jar.AffectedClasses;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarSnapshot {
    private final JarSnapshotData data;

    public JarSnapshot(JarSnapshotData data) {
        this.data = data;
    }

    public DependentsSet getAllClasses() {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, byte[]> cls : this.getHashes().entrySet()) {
            String className = cls.getKey();
            if (this.getAnalysis().isDependencyToAll(className)) {
                return new DependencyToAll();
            }
            result.add(className);
        }
        return new DefaultDependentsSet(result);
    }

    public AffectedClasses getAffectedClassesSince(JarSnapshot other) {
        DependentsSet affectedClasses = this.affectedSince(other);
        Set<String> addedClasses = this.addedSince(other);
        return new AffectedClasses(affectedClasses, addedClasses);
    }

    private DependentsSet affectedSince(JarSnapshot other) {
        HashSet<String> affected = new HashSet<String>();
        for (Map.Entry<String, byte[]> otherClass : other.getHashes().entrySet()) {
            String otherClassName = otherClass.getKey();
            byte[] otherClassBytes = otherClass.getValue();
            byte[] thisClsBytes = this.getHashes().get(otherClassName);
            if (thisClsBytes != null && Arrays.equals(thisClsBytes, otherClassBytes)) continue;
            affected.add(otherClassName);
            DependentsSet dependents = other.getAnalysis().getRelevantDependents(otherClassName);
            if (dependents.isDependencyToAll()) {
                return dependents;
            }
            affected.addAll(dependents.getDependentClasses());
        }
        return new DefaultDependentsSet(affected);
    }

    private Set<String> addedSince(JarSnapshot other) {
        HashSet<String> addedClasses = new HashSet<String>(this.getClasses());
        addedClasses.removeAll(other.getClasses());
        return addedClasses;
    }

    public byte[] getHash() {
        return this.data.hash;
    }

    public Map<String, byte[]> getHashes() {
        return this.data.hashes;
    }

    public ClassSetAnalysis getAnalysis() {
        return new ClassSetAnalysis(this.data.data);
    }

    public Set<String> getClasses() {
        return this.data.hashes.keySet();
    }

    public JarSnapshotData getData() {
        return this.data;
    }
}

