/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import org.gradle.api.internal.tasks.compile.incremental.deps.DefaultDependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependencyToAll;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.jar.AffectedClasses;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.model.PreviousCompilation;
import org.gradle.api.tasks.incremental.InputFileDetails;

public class JarChangeDependentsFinder {
    private final JarClasspathSnapshot jarClasspathSnapshot;
    private final PreviousCompilation previousCompilation;

    public JarChangeDependentsFinder(JarClasspathSnapshot jarClasspathSnapshot, PreviousCompilation previousCompilation) {
        this.jarClasspathSnapshot = jarClasspathSnapshot;
        this.previousCompilation = previousCompilation;
    }

    public DependentsSet getActualDependents(InputFileDetails jarChangeDetails, JarArchive jarArchive) {
        if (jarChangeDetails.isAdded()) {
            if (this.jarClasspathSnapshot.isAnyClassDuplicated(jarArchive)) {
                return new DependencyToAll("at least one of the classes of '" + jarArchive.file.getName() + "' is already present in classpath");
            }
            return new DefaultDependentsSet();
        }
        JarSnapshot previous = this.previousCompilation.getJarSnapshot(jarChangeDetails.getFile());
        if (previous == null) {
            return new DependencyToAll("missing jar snapshot of '" + jarArchive.file.getName() + "' from previous build");
        }
        if (jarChangeDetails.isRemoved()) {
            DependentsSet allClasses = previous.getAllClasses();
            if (allClasses.isDependencyToAll()) {
                return new DependencyToAll("at least one of the classes of removed jar '" + jarArchive.file.getName() + "' requires it");
            }
            return this.previousCompilation.getDependents(allClasses.getDependentClasses());
        }
        if (jarChangeDetails.isModified()) {
            JarSnapshot currentSnapshot = this.jarClasspathSnapshot.getSnapshot(jarArchive);
            AffectedClasses affected = currentSnapshot.getAffectedClassesSince(previous);
            if (affected.getAltered().isDependencyToAll()) {
                return affected.getAltered();
            }
            if (this.jarClasspathSnapshot.isAnyClassDuplicated(affected.getAdded())) {
                return new DependencyToAll("at least one of the classes of modified jar '" + jarArchive.file.getName() + "' is already present in the classpath");
            }
            return this.previousCompilation.getDependents(affected.getAltered().getDependentClasses());
        }
        throw new IllegalArgumentException("Unknown input file details provided: " + jarChangeDetails);
    }
}

