/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DefaultClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DefaultDependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependencyToAll;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.messaging.serialize.BaseSerializerFactory;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.MapSerializer;
import org.gradle.messaging.serialize.Serializer;
import org.gradle.messaging.serialize.SetSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSetAnalysisDataSerializer
implements Serializer<ClassSetAnalysisData> {
    private final MapSerializer<String, DependentsSet> serializer = new MapSerializer(BaseSerializerFactory.STRING_SERIALIZER, (Serializer)new DependentsSetSerializer());

    public DefaultClassSetAnalysisData read(Decoder decoder) throws Exception {
        return new DefaultClassSetAnalysisData(this.serializer.read(decoder));
    }

    public void write(Encoder encoder, ClassSetAnalysisData value) throws Exception {
        DefaultClassSetAnalysisData data = (DefaultClassSetAnalysisData)value;
        this.serializer.write(encoder, data.dependents);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependentsSetSerializer
    implements Serializer<DependentsSet> {
        private SetSerializer<String> setSerializer = new SetSerializer(BaseSerializerFactory.STRING_SERIALIZER, false);

        private DependentsSetSerializer() {
        }

        public DependentsSet read(Decoder decoder) throws Exception {
            int control = decoder.readSmallInt();
            if (control == 0) {
                return new DependencyToAll();
            }
            if (control != 1 && control != 2) {
                throw new IllegalArgumentException("Unable to read the data. Unexpected control value: " + control);
            }
            Set classes = this.setSerializer.read(decoder);
            return new DefaultDependentsSet(control == 1, classes);
        }

        public void write(Encoder encoder, DependentsSet value) throws Exception {
            if (value instanceof DependencyToAll) {
                encoder.writeSmallInt(0);
            } else if (value instanceof DefaultDependentsSet) {
                encoder.writeSmallInt(value.isDependencyToAll() ? 1 : 2);
                this.setSerializer.write(encoder, value.getDependentClasses());
            } else {
                throw new IllegalArgumentException("Don't know how to serialize value of type: " + value.getClass() + ", value: " + value);
            }
        }
    }
}

