/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompiler;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.NormalizingJavaCompiler;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.compile.daemon.DaemonJavaCompiler;
import org.gradle.api.internal.tasks.compile.jdk6.Jdk6JavaCompiler;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.language.base.internal.compile.Compiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaCompilerFactory
implements JavaCompilerFactory {
    private final File daemonWorkingDir;
    private final CompilerDaemonFactory compilerDaemonFactory;

    public DefaultJavaCompilerFactory(File daemonWorkingDir, CompilerDaemonFactory compilerDaemonFactory) {
        this.daemonWorkingDir = daemonWorkingDir;
        this.compilerDaemonFactory = compilerDaemonFactory;
    }

    @Override
    public Compiler<JavaCompileSpec> createForJointCompilation(CompileOptions options) {
        return this.createTargetCompiler(options, true);
    }

    @Override
    public Compiler<JavaCompileSpec> create(CompileOptions options) {
        Compiler<JavaCompileSpec> result = this.createTargetCompiler(options, false);
        return new NormalizingJavaCompiler(result);
    }

    private Compiler<JavaCompileSpec> createTargetCompiler(CompileOptions options, boolean jointCompilation) {
        if (options.isFork() && options.getForkOptions().getExecutable() != null) {
            return new CommandLineJavaCompiler();
        }
        Jdk6JavaCompiler compiler = new Jdk6JavaCompiler();
        if (options.isFork() && !jointCompilation) {
            return new DaemonJavaCompiler(this.daemonWorkingDir, compiler, this.compilerDaemonFactory);
        }
        return compiler;
    }
}

