/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.tasks.compile.ArgCollector;
import org.gradle.api.internal.tasks.compile.ArgWriter;
import org.gradle.api.internal.tasks.compile.CompileSpecToArguments;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineJavaCompilerArgumentsGenerator
implements CompileSpecToArguments<JavaCompileSpec>,
Serializable {
    @Override
    public void collectArguments(JavaCompileSpec spec, ArgCollector collector) {
        for (String arg : this.generate(spec)) {
            collector.args(arg);
        }
    }

    public Iterable<String> generate(JavaCompileSpec spec) {
        List<String> remainingArgs;
        List<String> launcherOptions = new JavaCompilerArgumentsBuilder(spec).includeLauncherOptions(true).includeMainOptions(false).includeClasspath(false).build();
        Iterable allArgs = Iterables.concat(launcherOptions, remainingArgs = new JavaCompilerArgumentsBuilder(spec).includeSourceFiles(true).build());
        if (this.exceedsWindowsCommandLineLengthLimit(allArgs)) {
            return Iterables.concat(launcherOptions, this.shortenArgs(spec.getTempDir(), remainingArgs));
        }
        return allArgs;
    }

    private boolean exceedsWindowsCommandLineLengthLimit(Iterable<String> args) {
        int length = 0;
        for (String arg : args) {
            if ((length += arg.length() + 1) <= 1500) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<String> shortenArgs(File tempDir, List<String> args) {
        File file = new File(tempDir, "java-compiler-args.txt");
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(file));
            try {
                ArgWriter argWriter = ArgWriter.unixStyle(writer);
                for (String arg : args) {
                    argWriter.args(arg);
                }
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
        return Collections.singleton("@" + file.getPath());
    }
}

