/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.Iterables;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.GroovySystem;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.tools.javac.JavaAwareCompilationUnit;
import org.codehaus.groovy.tools.javac.JavaCompiler;
import org.codehaus.groovy.tools.javac.JavaCompilerFactory;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.GroovyCompileTransformingClassLoader;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.VersionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiGroovyCompiler
implements Compiler<GroovyJavaJointCompileSpec>,
Serializable {
    private final Compiler<JavaCompileSpec> javaCompiler;

    public ApiGroovyCompiler(Compiler<JavaCompileSpec> javaCompiler) {
        this.javaCompiler = javaCompiler;
    }

    public WorkResult execute(final GroovyJavaJointCompileSpec spec) {
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.setVerbose(spec.getGroovyCompileOptions().isVerbose());
        configuration.setSourceEncoding(spec.getGroovyCompileOptions().getEncoding());
        configuration.setTargetBytecode(spec.getTargetCompatibility());
        configuration.setTargetDirectory(spec.getDestinationDir());
        this.canonicalizeValues(spec.getGroovyCompileOptions().getOptimizationOptions());
        if (spec.getGroovyCompileOptions().getConfigurationScript() != null) {
            this.applyConfigurationScript(spec.getGroovyCompileOptions().getConfigurationScript(), configuration);
        }
        try {
            configuration.setOptimizationOptions(spec.getGroovyCompileOptions().getOptimizationOptions());
        }
        catch (NoSuchMethodError ignored) {
            // empty catch block
        }
        HashMap<String, Comparable<File>> jointCompilationOptions = new HashMap<String, Comparable<File>>();
        jointCompilationOptions.put("stubDir", spec.getGroovyCompileOptions().getStubDir());
        jointCompilationOptions.put("keepStubs", Boolean.valueOf(spec.getGroovyCompileOptions().isKeepStubs()));
        configuration.setJointCompilationOptions(jointCompilationOptions);
        GroovyCompileTransformingClassLoader classPathLoader = new GroovyCompileTransformingClassLoader((ClassPath)new DefaultClassPath(spec.getClasspath()));
        GroovyClassLoader compileClasspathClassLoader = new GroovyClassLoader((ClassLoader)((Object)classPathLoader), null);
        FilteringClassLoader groovyCompilerClassLoader = new FilteringClassLoader(GroovyClassLoader.class.getClassLoader());
        groovyCompilerClassLoader.allowPackage("org.codehaus.groovy");
        groovyCompilerClassLoader.allowPackage("groovy");
        groovyCompilerClassLoader.disallowClass("groovy.util.GroovyTestCase");
        groovyCompilerClassLoader.disallowClass("groovy.servlet.GroovyServlet");
        final GroovyClassLoader astTransformClassLoader = new GroovyClassLoader((ClassLoader)groovyCompilerClassLoader, null);
        for (File file : spec.getClasspath()) {
            astTransformClassLoader.addClasspath(file.getPath());
        }
        JavaAwareCompilationUnit unit = new JavaAwareCompilationUnit(configuration, compileClasspathClassLoader){

            public GroovyClassLoader getTransformLoader() {
                return astTransformClassLoader;
            }
        };
        unit.addSources((File[])Iterables.toArray((Iterable)spec.getSource(), File.class));
        unit.setCompilerFactory(new JavaCompilerFactory(){

            public JavaCompiler createCompiler(final CompilerConfiguration config) {
                return new JavaCompiler(){

                    public void compile(List<String> files, CompilationUnit cu) {
                        spec.setSource(spec.getSource().filter((Spec)new Spec<File>(){

                            public boolean isSatisfiedBy(File file) {
                                return file.getName().endsWith(".java");
                            }
                        }));
                        spec.getCompileOptions().getCompilerArgs().add("-sourcepath");
                        spec.getCompileOptions().getCompilerArgs().add(((File)config.getJointCompilationOptions().get("stubDir")).getAbsolutePath());
                        try {
                            ApiGroovyCompiler.this.javaCompiler.execute((CompileSpec)spec);
                        }
                        catch (CompilationFailedException e) {
                            cu.getErrorCollector().addFatalError((Message)new SimpleMessage(e.getMessage(), (ProcessingUnit)cu));
                        }
                    }
                };
            }
        });
        try {
            unit.compile();
        }
        catch (org.codehaus.groovy.control.CompilationFailedException e) {
            System.err.println(e.getMessage());
            throw new CompilationFailedException();
        }
        return new SimpleWorkResult(true);
    }

    private void applyConfigurationScript(File configScript, CompilerConfiguration configuration) {
        VersionNumber version = this.parseGroovyVersion();
        if (version.compareTo(VersionNumber.parse((String)"2.1")) < 0) {
            throw new GradleException("Using a Groovy compiler configuration script requires Groovy 2.1+ but found Groovy " + version + "");
        }
        Binding binding = new Binding();
        binding.setVariable("configuration", (Object)configuration);
        CompilerConfiguration configuratorConfig = new CompilerConfiguration();
        ImportCustomizer customizer = new ImportCustomizer();
        customizer.addStaticStars(new String[]{"org.codehaus.groovy.control.customizers.builder.CompilerCustomizationBuilder"});
        configuratorConfig.addCompilationCustomizers(new CompilationCustomizer[]{customizer});
        GroovyShell shell = new GroovyShell(binding, configuratorConfig);
        try {
            shell.evaluate(configScript);
        }
        catch (Exception e) {
            throw new GradleException("Could not execute Groovy compiler configuration script: " + configScript.getAbsolutePath(), (Throwable)e);
        }
    }

    private VersionNumber parseGroovyVersion() {
        String version;
        try {
            version = GroovySystem.getVersion();
        }
        catch (NoSuchMethodError e) {
            try {
                Class<?> ih = Class.forName("org.codehaus.groovy.runtime.InvokerHelper");
                Method getVersion = ih.getDeclaredMethod("getVersion", new Class[0]);
                version = (String)getVersion.invoke(ih, new Object[0]);
            }
            catch (Exception e1) {
                throw new GradleException("Unable to determine Groovy version.", (Throwable)e1);
            }
        }
        return VersionNumber.parse((String)version);
    }

    private void canonicalizeValues(Map<String, Boolean> options) {
        for (String key : options.keySet()) {
            boolean value = options.get(key);
            options.put(key, value);
        }
    }
}

