/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.JavaVersion;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerFactory;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.javadoc.internal.JavadocGenerator;
import org.gradle.api.tasks.javadoc.internal.JavadocSpec;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.runtime.jvm.internal.toolchain.JavaToolChainInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaToolChain
implements JavaToolChainInternal {
    private final JavaCompilerFactory compilerFactory;
    private final ExecActionFactory execActionFactory;

    public DefaultJavaToolChain(JavaCompilerFactory compilerFactory, ExecActionFactory execActionFactory) {
        this.compilerFactory = compilerFactory;
        this.execActionFactory = execActionFactory;
    }

    @Override
    public String getDisplayName() {
        return String.format("current JDK (%s)", JavaVersion.current());
    }

    public String toString() {
        return this.getDisplayName();
    }

    public <T extends CompileSpec> Compiler<T> newCompiler(T spec) {
        if (spec instanceof JavaCompileSpec) {
            CompileOptions options = ((JavaCompileSpec)spec).getCompileOptions();
            return this.compilerFactory.create(options);
        }
        if (spec instanceof JavadocSpec) {
            return new JavadocGenerator(this.execActionFactory);
        }
        throw new IllegalArgumentException(String.format("Don't know how to compile using spec of type %s.", spec.getClass().getSimpleName()));
    }
}

