/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.sonatype.aether.resolution;

import java.util.ArrayList;
import java.util.List;
import org.gradle.mvn3.org.sonatype.aether.artifact.Artifact;
import org.gradle.mvn3.org.sonatype.aether.repository.ArtifactRepository;
import org.gradle.mvn3.org.sonatype.aether.resolution.ArtifactRequest;
import org.gradle.mvn3.org.sonatype.aether.transfer.ArtifactNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactResult {
    private final ArtifactRequest request;
    private final List<Exception> exceptions;
    private Artifact artifact;
    private ArtifactRepository repository;

    public ArtifactResult(ArtifactRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("resolution request has not been specified");
        }
        this.request = request;
        this.exceptions = new ArrayList<Exception>(2);
    }

    public ArtifactRequest getRequest() {
        return this.request;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public ArtifactResult setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public ArtifactResult addException(Exception exception) {
        if (exception != null) {
            this.exceptions.add(exception);
        }
        return this;
    }

    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public ArtifactResult setRepository(ArtifactRepository repository) {
        this.repository = repository;
        return this;
    }

    public boolean isResolved() {
        return this.getArtifact() != null && this.getArtifact().getFile() != null;
    }

    public boolean isMissing() {
        for (Exception e : this.getExceptions()) {
            if (e instanceof ArtifactNotFoundException) continue;
            return false;
        }
        return !this.isResolved();
    }

    public String toString() {
        return this.getArtifact() + " < " + this.getRepository();
    }
}

