/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.mvn3.org.sonatype.aether.resolution;

import org.gradle.mvn3.org.sonatype.aether.RepositoryException;
import org.gradle.mvn3.org.sonatype.aether.resolution.ArtifactDescriptorResult;

public class ArtifactDescriptorException
extends RepositoryException {
    private final ArtifactDescriptorResult result;

    public ArtifactDescriptorException(ArtifactDescriptorResult result, String message) {
        super(message, ArtifactDescriptorException.getCause(result));
        this.result = result;
    }

    public ArtifactDescriptorException(ArtifactDescriptorResult result) {
        super("Failed to read artifact descriptor" + (result != null ? " for " + result.getRequest().getArtifact() : ""), ArtifactDescriptorException.getCause(result));
        this.result = result;
    }

    public ArtifactDescriptorResult getResult() {
        return this.result;
    }

    private static Throwable getCause(ArtifactDescriptorResult result) {
        Throwable cause = null;
        if (result != null && !result.getExceptions().isEmpty()) {
            cause = result.getExceptions().get(0);
        }
        return cause;
    }
}

